/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.deploymentstacks.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.deploymentstacks.DeploymentStacksManager;
import com.azure.resourcemanager.resources.deploymentstacks.fluent.models.DeploymentStackInner;
import com.azure.resourcemanager.resources.deploymentstacks.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStack;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStackProperties;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStackTemplateDefinition;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStackValidateResult;
import java.util.Collections;
import java.util.Map;

public final class DeploymentStackImpl
implements DeploymentStack,
DeploymentStack.Definition,
DeploymentStack.Update {
    private DeploymentStackInner innerObject;
    private final DeploymentStacksManager serviceManager;
    private String resourceGroupName;
    private String deploymentStackName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public DeploymentStackProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DeploymentStackInner innerModel() {
        return this.innerObject;
    }

    private DeploymentStacksManager manager() {
        return this.serviceManager;
    }

    @Override
    public DeploymentStackImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DeploymentStack create() {
        this.innerObject = this.serviceManager.serviceClient().getDeploymentStacks().createOrUpdateAtResourceGroup(this.resourceGroupName, this.deploymentStackName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DeploymentStack create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDeploymentStacks().createOrUpdateAtResourceGroup(this.resourceGroupName, this.deploymentStackName, this.innerModel(), context);
        return this;
    }

    DeploymentStackImpl(String name, DeploymentStacksManager serviceManager) {
        this.innerObject = new DeploymentStackInner();
        this.serviceManager = serviceManager;
        this.deploymentStackName = name;
    }

    @Override
    public DeploymentStackImpl update() {
        return this;
    }

    @Override
    public DeploymentStack apply() {
        this.innerObject = this.serviceManager.serviceClient().getDeploymentStacks().createOrUpdateAtResourceGroup(this.resourceGroupName, this.deploymentStackName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DeploymentStack apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDeploymentStacks().createOrUpdateAtResourceGroup(this.resourceGroupName, this.deploymentStackName, this.innerModel(), context);
        return this;
    }

    DeploymentStackImpl(DeploymentStackInner innerObject, DeploymentStacksManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.deploymentStackName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "deploymentStacks");
    }

    @Override
    public DeploymentStack refresh() {
        this.innerObject = (DeploymentStackInner)((Object)this.serviceManager.serviceClient().getDeploymentStacks().getByResourceGroupWithResponse(this.resourceGroupName, this.deploymentStackName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DeploymentStack refresh(Context context) {
        this.innerObject = (DeploymentStackInner)((Object)this.serviceManager.serviceClient().getDeploymentStacks().getByResourceGroupWithResponse(this.resourceGroupName, this.deploymentStackName, context).getValue());
        return this;
    }

    @Override
    public Response<DeploymentStackTemplateDefinition> exportTemplateAtResourceGroupWithResponse(Context context) {
        return this.serviceManager.deploymentStacks().exportTemplateAtResourceGroupWithResponse(this.resourceGroupName, this.deploymentStackName, context);
    }

    @Override
    public DeploymentStackTemplateDefinition exportTemplateAtResourceGroup() {
        return this.serviceManager.deploymentStacks().exportTemplateAtResourceGroup(this.resourceGroupName, this.deploymentStackName);
    }

    @Override
    public DeploymentStackValidateResult validateStackAtResourceGroup(DeploymentStackInner deploymentStack) {
        return this.serviceManager.deploymentStacks().validateStackAtResourceGroup(this.resourceGroupName, this.deploymentStackName, deploymentStack);
    }

    @Override
    public DeploymentStackValidateResult validateStackAtResourceGroup(DeploymentStackInner deploymentStack, Context context) {
        return this.serviceManager.deploymentStacks().validateStackAtResourceGroup(this.resourceGroupName, this.deploymentStackName, deploymentStack, context);
    }

    @Override
    public DeploymentStackImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DeploymentStackImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DeploymentStackImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    @Override
    public DeploymentStackImpl withProperties(DeploymentStackProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

