/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.bicep.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.bicep.BicepProviderManager;
import com.azure.resourcemanager.resources.bicep.fluent.DecompileOperationGroupsClient;
import com.azure.resourcemanager.resources.bicep.fluent.models.DecompileOperationSuccessResponseInner;
import com.azure.resourcemanager.resources.bicep.implementation.DecompileOperationSuccessResponseImpl;
import com.azure.resourcemanager.resources.bicep.models.DecompileOperationGroups;
import com.azure.resourcemanager.resources.bicep.models.DecompileOperationRequest;
import com.azure.resourcemanager.resources.bicep.models.DecompileOperationSuccessResponse;

public final class DecompileOperationGroupsImpl
implements DecompileOperationGroups {
    private static final ClientLogger LOGGER = new ClientLogger(DecompileOperationGroupsImpl.class);
    private final DecompileOperationGroupsClient innerClient;
    private final BicepProviderManager serviceManager;

    public DecompileOperationGroupsImpl(DecompileOperationGroupsClient innerClient, BicepProviderManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DecompileOperationSuccessResponse> bicepWithResponse(DecompileOperationRequest decompileOperationRequest, Context context) {
        Response<DecompileOperationSuccessResponseInner> inner = this.serviceClient().bicepWithResponse(decompileOperationRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DecompileOperationSuccessResponseImpl((DecompileOperationSuccessResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DecompileOperationSuccessResponse bicep(DecompileOperationRequest decompileOperationRequest) {
        DecompileOperationSuccessResponseInner inner = this.serviceClient().bicep(decompileOperationRequest);
        if (inner != null) {
            return new DecompileOperationSuccessResponseImpl(inner, this.manager());
        }
        return null;
    }

    private DecompileOperationGroupsClient serviceClient() {
        return this.innerClient;
    }

    private BicepProviderManager manager() {
        return this.serviceManager;
    }
}

