/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.bicep.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.bicep.fluent.DecompileOperationGroupsClient;
import com.azure.resourcemanager.resources.bicep.fluent.models.DecompileOperationSuccessResponseInner;
import com.azure.resourcemanager.resources.bicep.implementation.BicepProviderManagementClientImpl;
import com.azure.resourcemanager.resources.bicep.models.DecompileOperationRequest;
import reactor.core.publisher.Mono;

public final class DecompileOperationGroupsClientImpl
implements DecompileOperationGroupsClient {
    private final DecompileOperationGroupsService service;
    private final BicepProviderManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(DecompileOperationGroupsClientImpl.class);

    DecompileOperationGroupsClientImpl(BicepProviderManagementClientImpl client) {
        this.service = (DecompileOperationGroupsService)RestProxy.create(DecompileOperationGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DecompileOperationSuccessResponseInner>> bicepWithResponseAsync(DecompileOperationRequest decompileOperationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (decompileOperationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter decompileOperationRequest is required and cannot be null."));
        }
        decompileOperationRequest.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.bicep(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", "application/json", decompileOperationRequest, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DecompileOperationSuccessResponseInner> bicepAsync(DecompileOperationRequest decompileOperationRequest) {
        return this.bicepWithResponseAsync(decompileOperationRequest).flatMap(res -> Mono.justOrEmpty((Object)((DecompileOperationSuccessResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DecompileOperationSuccessResponseInner> bicepWithResponse(DecompileOperationRequest decompileOperationRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (decompileOperationRequest == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter decompileOperationRequest is required and cannot be null."));
        }
        decompileOperationRequest.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.bicepSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", "application/json", decompileOperationRequest, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DecompileOperationSuccessResponseInner bicep(DecompileOperationRequest decompileOperationRequest) {
        return (DecompileOperationSuccessResponseInner)this.bicepWithResponse(decompileOperationRequest, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="BicepProviderManagementClientDecompileOperationGroups")
    public static interface DecompileOperationGroupsService {
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/decompileBicep")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DecompileOperationSuccessResponseInner>> bicep(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") DecompileOperationRequest var6, Context var7);

        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/decompileBicep")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DecompileOperationSuccessResponseInner> bicepSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") DecompileOperationRequest var6, Context var7);
    }
}

