/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.bicep.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.bicep.models.FileDefinition;
import java.io.IOException;
import java.util.List;

public final class DecompileOperationSuccessResponseInner
implements JsonSerializable<DecompileOperationSuccessResponseInner> {
    private List<FileDefinition> files;
    private String entryPoint;
    private static final ClientLogger LOGGER = new ClientLogger(DecompileOperationSuccessResponseInner.class);

    private DecompileOperationSuccessResponseInner() {
    }

    public List<FileDefinition> files() {
        return this.files;
    }

    public String entryPoint() {
        return this.entryPoint;
    }

    public void validate() {
        if (this.files() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property files in model DecompileOperationSuccessResponseInner"));
        }
        this.files().forEach(e -> e.validate());
        if (this.entryPoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property entryPoint in model DecompileOperationSuccessResponseInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("files", this.files, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("entryPoint", this.entryPoint);
        return jsonWriter.writeEndObject();
    }

    public static DecompileOperationSuccessResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (DecompileOperationSuccessResponseInner)jsonReader.readObject(reader -> {
            DecompileOperationSuccessResponseInner deserializedDecompileOperationSuccessResponseInner = new DecompileOperationSuccessResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("files".equals(fieldName)) {
                    List files;
                    deserializedDecompileOperationSuccessResponseInner.files = files = reader.readArray(reader1 -> FileDefinition.fromJson(reader1));
                    continue;
                }
                if ("entryPoint".equals(fieldName)) {
                    deserializedDecompileOperationSuccessResponseInner.entryPoint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDecompileOperationSuccessResponseInner;
        });
    }
}

