/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.models.AccessKeyType;
import java.io.IOException;

public final class RegenerateKeyParameters
implements JsonSerializable<RegenerateKeyParameters> {
    private AccessKeyType keyType;
    private static final ClientLogger LOGGER = new ClientLogger(RegenerateKeyParameters.class);

    public AccessKeyType keyType() {
        return this.keyType;
    }

    public RegenerateKeyParameters withKeyType(AccessKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public void validate() {
        if (this.keyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyType in model RegenerateKeyParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyType", this.keyType == null ? null : this.keyType.toString());
        return jsonWriter.writeEndObject();
    }

    public static RegenerateKeyParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RegenerateKeyParameters)jsonReader.readObject(reader -> {
            RegenerateKeyParameters deserializedRegenerateKeyParameters = new RegenerateKeyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyType".equals(fieldName)) {
                    deserializedRegenerateKeyParameters.keyType = AccessKeyType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegenerateKeyParameters;
        });
    }
}

