/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.models.AccessKeysAuthentication;
import com.azure.resourcemanager.redisenterprise.models.ClusteringPolicy;
import com.azure.resourcemanager.redisenterprise.models.DatabasePropertiesGeoReplication;
import com.azure.resourcemanager.redisenterprise.models.DeferUpgradeSetting;
import com.azure.resourcemanager.redisenterprise.models.EvictionPolicy;
import com.azure.resourcemanager.redisenterprise.models.Module;
import com.azure.resourcemanager.redisenterprise.models.Persistence;
import com.azure.resourcemanager.redisenterprise.models.Protocol;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import java.io.IOException;
import java.util.List;

public class DatabaseCommonProperties
implements JsonSerializable<DatabaseCommonProperties> {
    private Protocol clientProtocol;
    private Integer port;
    private ProvisioningState provisioningState;
    private ResourceState resourceState;
    private ClusteringPolicy clusteringPolicy;
    private EvictionPolicy evictionPolicy;
    private Persistence persistence;
    private List<Module> modules;
    private DatabasePropertiesGeoReplication geoReplication;
    private String redisVersion;
    private DeferUpgradeSetting deferUpgrade;
    private AccessKeysAuthentication accessKeysAuthentication;

    public Protocol clientProtocol() {
        return this.clientProtocol;
    }

    public DatabaseCommonProperties withClientProtocol(Protocol clientProtocol) {
        this.clientProtocol = clientProtocol;
        return this;
    }

    public Integer port() {
        return this.port;
    }

    public DatabaseCommonProperties withPort(Integer port) {
        this.port = port;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    DatabaseCommonProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public ResourceState resourceState() {
        return this.resourceState;
    }

    DatabaseCommonProperties withResourceState(ResourceState resourceState) {
        this.resourceState = resourceState;
        return this;
    }

    public ClusteringPolicy clusteringPolicy() {
        return this.clusteringPolicy;
    }

    public DatabaseCommonProperties withClusteringPolicy(ClusteringPolicy clusteringPolicy) {
        this.clusteringPolicy = clusteringPolicy;
        return this;
    }

    public EvictionPolicy evictionPolicy() {
        return this.evictionPolicy;
    }

    public DatabaseCommonProperties withEvictionPolicy(EvictionPolicy evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public Persistence persistence() {
        return this.persistence;
    }

    public DatabaseCommonProperties withPersistence(Persistence persistence) {
        this.persistence = persistence;
        return this;
    }

    public List<Module> modules() {
        return this.modules;
    }

    public DatabaseCommonProperties withModules(List<Module> modules) {
        this.modules = modules;
        return this;
    }

    public DatabasePropertiesGeoReplication geoReplication() {
        return this.geoReplication;
    }

    public DatabaseCommonProperties withGeoReplication(DatabasePropertiesGeoReplication geoReplication) {
        this.geoReplication = geoReplication;
        return this;
    }

    public String redisVersion() {
        return this.redisVersion;
    }

    DatabaseCommonProperties withRedisVersion(String redisVersion) {
        this.redisVersion = redisVersion;
        return this;
    }

    public DeferUpgradeSetting deferUpgrade() {
        return this.deferUpgrade;
    }

    public DatabaseCommonProperties withDeferUpgrade(DeferUpgradeSetting deferUpgrade) {
        this.deferUpgrade = deferUpgrade;
        return this;
    }

    public AccessKeysAuthentication accessKeysAuthentication() {
        return this.accessKeysAuthentication;
    }

    public DatabaseCommonProperties withAccessKeysAuthentication(AccessKeysAuthentication accessKeysAuthentication) {
        this.accessKeysAuthentication = accessKeysAuthentication;
        return this;
    }

    public void validate() {
        if (this.persistence() != null) {
            this.persistence().validate();
        }
        if (this.modules() != null) {
            this.modules().forEach(e -> e.validate());
        }
        if (this.geoReplication() != null) {
            this.geoReplication().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientProtocol", this.clientProtocol == null ? null : this.clientProtocol.toString());
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeStringField("clusteringPolicy", this.clusteringPolicy == null ? null : this.clusteringPolicy.toString());
        jsonWriter.writeStringField("evictionPolicy", this.evictionPolicy == null ? null : this.evictionPolicy.toString());
        jsonWriter.writeJsonField("persistence", (JsonSerializable)this.persistence);
        jsonWriter.writeArrayField("modules", this.modules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("geoReplication", (JsonSerializable)this.geoReplication);
        jsonWriter.writeStringField("deferUpgrade", this.deferUpgrade == null ? null : this.deferUpgrade.toString());
        jsonWriter.writeStringField("accessKeysAuthentication", this.accessKeysAuthentication == null ? null : this.accessKeysAuthentication.toString());
        return jsonWriter.writeEndObject();
    }

    public static DatabaseCommonProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseCommonProperties)jsonReader.readObject(reader -> {
            DatabaseCommonProperties deserializedDatabaseCommonProperties = new DatabaseCommonProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientProtocol".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.clientProtocol = Protocol.fromString(reader.getString());
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.resourceState = ResourceState.fromString(reader.getString());
                    continue;
                }
                if ("clusteringPolicy".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.clusteringPolicy = ClusteringPolicy.fromString(reader.getString());
                    continue;
                }
                if ("evictionPolicy".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.evictionPolicy = EvictionPolicy.fromString(reader.getString());
                    continue;
                }
                if ("persistence".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.persistence = Persistence.fromJson(reader);
                    continue;
                }
                if ("modules".equals(fieldName)) {
                    List modules;
                    deserializedDatabaseCommonProperties.modules = modules = reader.readArray(reader1 -> Module.fromJson(reader1));
                    continue;
                }
                if ("geoReplication".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.geoReplication = DatabasePropertiesGeoReplication.fromJson(reader);
                    continue;
                }
                if ("redisVersion".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.redisVersion = reader.getString();
                    continue;
                }
                if ("deferUpgrade".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.deferUpgrade = DeferUpgradeSetting.fromString(reader.getString());
                    continue;
                }
                if ("accessKeysAuthentication".equals(fieldName)) {
                    deserializedDatabaseCommonProperties.accessKeysAuthentication = AccessKeysAuthentication.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseCommonProperties;
        });
    }
}

