/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redisenterprise.models.ClusterPropertiesEncryption;
import com.azure.resourcemanager.redisenterprise.models.HighAvailability;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.RedundancyMode;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import com.azure.resourcemanager.redisenterprise.models.TlsVersion;
import java.io.IOException;
import java.util.List;

public class ClusterCommonProperties
implements JsonSerializable<ClusterCommonProperties> {
    private HighAvailability highAvailability;
    private TlsVersion minimumTlsVersion;
    private ClusterPropertiesEncryption encryption;
    private String hostname;
    private ProvisioningState provisioningState;
    private RedundancyMode redundancyMode;
    private ResourceState resourceState;
    private String redisVersion;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    public HighAvailability highAvailability() {
        return this.highAvailability;
    }

    public ClusterCommonProperties withHighAvailability(HighAvailability highAvailability) {
        this.highAvailability = highAvailability;
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public ClusterCommonProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public ClusterPropertiesEncryption encryption() {
        return this.encryption;
    }

    public ClusterCommonProperties withEncryption(ClusterPropertiesEncryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    ClusterCommonProperties withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    ClusterCommonProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public RedundancyMode redundancyMode() {
        return this.redundancyMode;
    }

    ClusterCommonProperties withRedundancyMode(RedundancyMode redundancyMode) {
        this.redundancyMode = redundancyMode;
        return this;
    }

    public ResourceState resourceState() {
        return this.resourceState;
    }

    ClusterCommonProperties withResourceState(ResourceState resourceState) {
        this.resourceState = resourceState;
        return this;
    }

    public String redisVersion() {
        return this.redisVersion;
    }

    ClusterCommonProperties withRedisVersion(String redisVersion) {
        this.redisVersion = redisVersion;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    ClusterCommonProperties withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public void validate() {
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("highAvailability", this.highAvailability == null ? null : this.highAvailability.toString());
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion == null ? null : this.minimumTlsVersion.toString());
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        return jsonWriter.writeEndObject();
    }

    public static ClusterCommonProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterCommonProperties)jsonReader.readObject(reader -> {
            ClusterCommonProperties deserializedClusterCommonProperties = new ClusterCommonProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("highAvailability".equals(fieldName)) {
                    deserializedClusterCommonProperties.highAvailability = HighAvailability.fromString(reader.getString());
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedClusterCommonProperties.minimumTlsVersion = TlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedClusterCommonProperties.encryption = ClusterPropertiesEncryption.fromJson(reader);
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedClusterCommonProperties.hostname = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterCommonProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("redundancyMode".equals(fieldName)) {
                    deserializedClusterCommonProperties.redundancyMode = RedundancyMode.fromString(reader.getString());
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedClusterCommonProperties.resourceState = ResourceState.fromString(reader.getString());
                    continue;
                }
                if ("redisVersion".equals(fieldName)) {
                    deserializedClusterCommonProperties.redisVersion = reader.getString();
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedClusterCommonProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterCommonProperties;
        });
    }
}

