/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.redisenterprise.fluent.models.ClusterInner;
import com.azure.resourcemanager.redisenterprise.models.ClusterPropertiesEncryption;
import com.azure.resourcemanager.redisenterprise.models.HighAvailability;
import com.azure.resourcemanager.redisenterprise.models.Kind;
import com.azure.resourcemanager.redisenterprise.models.ManagedServiceIdentity;
import com.azure.resourcemanager.redisenterprise.models.PrivateEndpointConnection;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.PublicNetworkAccess;
import com.azure.resourcemanager.redisenterprise.models.RedundancyMode;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import com.azure.resourcemanager.redisenterprise.models.Sku;
import com.azure.resourcemanager.redisenterprise.models.SkuDetailsList;
import com.azure.resourcemanager.redisenterprise.models.TlsVersion;
import java.util.List;
import java.util.Map;

public interface Cluster {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public Kind kind();

    public Sku sku();

    public List<String> zones();

    public ManagedServiceIdentity identity();

    public PublicNetworkAccess publicNetworkAccess();

    public HighAvailability highAvailability();

    public TlsVersion minimumTlsVersion();

    public ClusterPropertiesEncryption encryption();

    public String hostname();

    public ProvisioningState provisioningState();

    public RedundancyMode redundancyMode();

    public ResourceState resourceState();

    public String redisVersion();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ClusterInner innerModel();

    public Update update();

    public Cluster refresh();

    public Cluster refresh(Context var1);

    public Response<SkuDetailsList> listSkusForScalingWithResponse(Context var1);

    public SkuDetailsList listSkusForScaling();

    public static interface UpdateStages {

        public static interface WithEncryption {
            public Update withEncryption(ClusterPropertiesEncryption var1);
        }

        public static interface WithMinimumTlsVersion {
            public Update withMinimumTlsVersion(TlsVersion var1);
        }

        public static interface WithHighAvailability {
            public Update withHighAvailability(HighAvailability var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithSku {
            public Update withSku(Sku var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSku,
    UpdateStages.WithIdentity,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithHighAvailability,
    UpdateStages.WithMinimumTlsVersion,
    UpdateStages.WithEncryption {
        public Cluster apply();

        public Cluster apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEncryption {
            public WithCreate withEncryption(ClusterPropertiesEncryption var1);
        }

        public static interface WithMinimumTlsVersion {
            public WithCreate withMinimumTlsVersion(TlsVersion var1);
        }

        public static interface WithHighAvailability {
            public WithCreate withHighAvailability(HighAvailability var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithZones {
            public WithCreate withZones(List<String> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithZones,
        WithIdentity,
        WithPublicNetworkAccess,
        WithHighAvailability,
        WithMinimumTlsVersion,
        WithEncryption {
            public Cluster create();

            public Cluster create(Context var1);
        }

        public static interface WithSku {
            public WithCreate withSku(Sku var1);
        }

        public static interface WithResourceGroup {
            public WithSku withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithCreate {
    }
}

