/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.redisenterprise.RedisEnterpriseManager;
import com.azure.resourcemanager.redisenterprise.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redisenterprise.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.redisenterprise.models.PrivateEndpoint;
import com.azure.resourcemanager.redisenterprise.models.PrivateEndpointConnection;
import com.azure.resourcemanager.redisenterprise.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.PrivateLinkServiceConnectionState;

public final class PrivateEndpointConnectionImpl
implements PrivateEndpointConnection,
PrivateEndpointConnection.Definition,
PrivateEndpointConnection.Update {
    private PrivateEndpointConnectionInner innerObject;
    private final RedisEnterpriseManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String privateEndpointConnectionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public PrivateEndpoint privateEndpoint() {
        return this.innerModel().privateEndpoint();
    }

    @Override
    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerModel().privateLinkServiceConnectionState();
    }

    @Override
    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PrivateEndpointConnectionInner innerModel() {
        return this.innerObject;
    }

    private RedisEnterpriseManager manager() {
        return this.serviceManager;
    }

    @Override
    public PrivateEndpointConnectionImpl withExistingRedisEnterprise(String resourceGroupName, String clusterName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public PrivateEndpointConnection create() {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().put(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PrivateEndpointConnection create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().put(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, this.innerModel(), context);
        return this;
    }

    PrivateEndpointConnectionImpl(String name, RedisEnterpriseManager serviceManager) {
        this.innerObject = new PrivateEndpointConnectionInner();
        this.serviceManager = serviceManager;
        this.privateEndpointConnectionName = name;
    }

    @Override
    public PrivateEndpointConnectionImpl update() {
        return this;
    }

    @Override
    public PrivateEndpointConnection apply() {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().put(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PrivateEndpointConnection apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().put(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, this.innerModel(), context);
        return this;
    }

    PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerObject, RedisEnterpriseManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "redisEnterprise");
        this.privateEndpointConnectionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "privateEndpointConnections");
    }

    @Override
    public PrivateEndpointConnection refresh() {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnections().getWithResponse(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnection refresh(Context context) {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnections().getWithResponse(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, context).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withPrivateEndpoint(PrivateEndpoint privateEndpoint) {
        this.innerModel().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.innerModel().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }
}

