/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redisenterprise.RedisEnterpriseManager;
import com.azure.resourcemanager.redisenterprise.fluent.AccessPolicyAssignmentsClient;
import com.azure.resourcemanager.redisenterprise.fluent.models.AccessPolicyAssignmentInner;
import com.azure.resourcemanager.redisenterprise.implementation.AccessPolicyAssignmentImpl;
import com.azure.resourcemanager.redisenterprise.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.redisenterprise.models.AccessPolicyAssignment;
import com.azure.resourcemanager.redisenterprise.models.AccessPolicyAssignments;

public final class AccessPolicyAssignmentsImpl
implements AccessPolicyAssignments {
    private static final ClientLogger LOGGER = new ClientLogger(AccessPolicyAssignmentsImpl.class);
    private final AccessPolicyAssignmentsClient innerClient;
    private final RedisEnterpriseManager serviceManager;

    public AccessPolicyAssignmentsImpl(AccessPolicyAssignmentsClient innerClient, RedisEnterpriseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AccessPolicyAssignment> getWithResponse(String resourceGroupName, String clusterName, String databaseName, String accessPolicyAssignmentName, Context context) {
        Response<AccessPolicyAssignmentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AccessPolicyAssignmentImpl((AccessPolicyAssignmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AccessPolicyAssignment get(String resourceGroupName, String clusterName, String databaseName, String accessPolicyAssignmentName) {
        AccessPolicyAssignmentInner inner = this.serviceClient().get(resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName);
        if (inner != null) {
            return new AccessPolicyAssignmentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String databaseName, String accessPolicyAssignmentName) {
        this.serviceClient().delete(resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName);
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String databaseName, String accessPolicyAssignmentName, Context context) {
        this.serviceClient().delete(resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName, context);
    }

    @Override
    public PagedIterable<AccessPolicyAssignment> list(String resourceGroupName, String clusterName, String databaseName) {
        PagedIterable<AccessPolicyAssignmentInner> inner = this.serviceClient().list(resourceGroupName, clusterName, databaseName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AccessPolicyAssignmentImpl((AccessPolicyAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AccessPolicyAssignment> list(String resourceGroupName, String clusterName, String databaseName, Context context) {
        PagedIterable<AccessPolicyAssignmentInner> inner = this.serviceClient().list(resourceGroupName, clusterName, databaseName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AccessPolicyAssignmentImpl((AccessPolicyAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public AccessPolicyAssignment getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "redisEnterprise");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'redisEnterprise'.", id)));
        }
        String databaseName = ResourceManagerUtils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String accessPolicyAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "accessPolicyAssignments");
        if (accessPolicyAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accessPolicyAssignments'.", id)));
        }
        return (AccessPolicyAssignment)this.getWithResponse(resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName, Context.NONE).getValue();
    }

    @Override
    public Response<AccessPolicyAssignment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "redisEnterprise");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'redisEnterprise'.", id)));
        }
        String databaseName = ResourceManagerUtils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String accessPolicyAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "accessPolicyAssignments");
        if (accessPolicyAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accessPolicyAssignments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "redisEnterprise");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'redisEnterprise'.", id)));
        }
        String databaseName = ResourceManagerUtils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String accessPolicyAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "accessPolicyAssignments");
        if (accessPolicyAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accessPolicyAssignments'.", id)));
        }
        this.delete(resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "redisEnterprise");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'redisEnterprise'.", id)));
        }
        String databaseName = ResourceManagerUtils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String accessPolicyAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "accessPolicyAssignments");
        if (accessPolicyAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accessPolicyAssignments'.", id)));
        }
        this.delete(resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName, context);
    }

    private AccessPolicyAssignmentsClient serviceClient() {
        return this.innerClient;
    }

    private RedisEnterpriseManager manager() {
        return this.serviceManager;
    }

    @Override
    public AccessPolicyAssignmentImpl define(String name) {
        return new AccessPolicyAssignmentImpl(name, this.manager());
    }
}

