/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.redisenterprise.RedisEnterpriseManager;
import com.azure.resourcemanager.redisenterprise.fluent.models.AccessPolicyAssignmentInner;
import com.azure.resourcemanager.redisenterprise.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.redisenterprise.models.AccessPolicyAssignment;
import com.azure.resourcemanager.redisenterprise.models.AccessPolicyAssignmentPropertiesUser;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;

public final class AccessPolicyAssignmentImpl
implements AccessPolicyAssignment,
AccessPolicyAssignment.Definition,
AccessPolicyAssignment.Update {
    private AccessPolicyAssignmentInner innerObject;
    private final RedisEnterpriseManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String databaseName;
    private String accessPolicyAssignmentName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String accessPolicyName() {
        return this.innerModel().accessPolicyName();
    }

    @Override
    public AccessPolicyAssignmentPropertiesUser user() {
        return this.innerModel().user();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AccessPolicyAssignmentInner innerModel() {
        return this.innerObject;
    }

    private RedisEnterpriseManager manager() {
        return this.serviceManager;
    }

    @Override
    public AccessPolicyAssignmentImpl withExistingDatabase(String resourceGroupName, String clusterName, String databaseName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        this.databaseName = databaseName;
        return this;
    }

    @Override
    public AccessPolicyAssignment create() {
        this.innerObject = this.serviceManager.serviceClient().getAccessPolicyAssignments().createUpdate(this.resourceGroupName, this.clusterName, this.databaseName, this.accessPolicyAssignmentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AccessPolicyAssignment create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAccessPolicyAssignments().createUpdate(this.resourceGroupName, this.clusterName, this.databaseName, this.accessPolicyAssignmentName, this.innerModel(), context);
        return this;
    }

    AccessPolicyAssignmentImpl(String name, RedisEnterpriseManager serviceManager) {
        this.innerObject = new AccessPolicyAssignmentInner();
        this.serviceManager = serviceManager;
        this.accessPolicyAssignmentName = name;
    }

    @Override
    public AccessPolicyAssignmentImpl update() {
        return this;
    }

    @Override
    public AccessPolicyAssignment apply() {
        this.innerObject = this.serviceManager.serviceClient().getAccessPolicyAssignments().createUpdate(this.resourceGroupName, this.clusterName, this.databaseName, this.accessPolicyAssignmentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AccessPolicyAssignment apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAccessPolicyAssignments().createUpdate(this.resourceGroupName, this.clusterName, this.databaseName, this.accessPolicyAssignmentName, this.innerModel(), context);
        return this;
    }

    AccessPolicyAssignmentImpl(AccessPolicyAssignmentInner innerObject, RedisEnterpriseManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "redisEnterprise");
        this.databaseName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "databases");
        this.accessPolicyAssignmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "accessPolicyAssignments");
    }

    @Override
    public AccessPolicyAssignment refresh() {
        this.innerObject = (AccessPolicyAssignmentInner)((Object)this.serviceManager.serviceClient().getAccessPolicyAssignments().getWithResponse(this.resourceGroupName, this.clusterName, this.databaseName, this.accessPolicyAssignmentName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AccessPolicyAssignment refresh(Context context) {
        this.innerObject = (AccessPolicyAssignmentInner)((Object)this.serviceManager.serviceClient().getAccessPolicyAssignments().getWithResponse(this.resourceGroupName, this.clusterName, this.databaseName, this.accessPolicyAssignmentName, context).getValue());
        return this;
    }

    @Override
    public AccessPolicyAssignmentImpl withAccessPolicyName(String accessPolicyName) {
        this.innerModel().withAccessPolicyName(accessPolicyName);
        return this;
    }

    @Override
    public AccessPolicyAssignmentImpl withUser(AccessPolicyAssignmentPropertiesUser user) {
        this.innerModel().withUser(user);
        return this;
    }
}

