/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.models.AccessKeysAuthentication;
import com.azure.resourcemanager.redisenterprise.models.ClusteringPolicy;
import com.azure.resourcemanager.redisenterprise.models.DatabaseCommonProperties;
import com.azure.resourcemanager.redisenterprise.models.DatabasePropertiesGeoReplication;
import com.azure.resourcemanager.redisenterprise.models.DeferUpgradeSetting;
import com.azure.resourcemanager.redisenterprise.models.EvictionPolicy;
import com.azure.resourcemanager.redisenterprise.models.Module;
import com.azure.resourcemanager.redisenterprise.models.Persistence;
import com.azure.resourcemanager.redisenterprise.models.Protocol;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import java.io.IOException;
import java.util.List;

public final class DatabaseCreateProperties
extends DatabaseCommonProperties {
    private String redisVersion;
    private ResourceState resourceState;
    private ProvisioningState provisioningState;

    @Override
    public String redisVersion() {
        return this.redisVersion;
    }

    @Override
    public ResourceState resourceState() {
        return this.resourceState;
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public DatabaseCreateProperties withClientProtocol(Protocol clientProtocol) {
        super.withClientProtocol(clientProtocol);
        return this;
    }

    @Override
    public DatabaseCreateProperties withPort(Integer port) {
        super.withPort(port);
        return this;
    }

    @Override
    public DatabaseCreateProperties withClusteringPolicy(ClusteringPolicy clusteringPolicy) {
        super.withClusteringPolicy(clusteringPolicy);
        return this;
    }

    @Override
    public DatabaseCreateProperties withEvictionPolicy(EvictionPolicy evictionPolicy) {
        super.withEvictionPolicy(evictionPolicy);
        return this;
    }

    @Override
    public DatabaseCreateProperties withPersistence(Persistence persistence) {
        super.withPersistence(persistence);
        return this;
    }

    @Override
    public DatabaseCreateProperties withModules(List<Module> modules) {
        super.withModules(modules);
        return this;
    }

    @Override
    public DatabaseCreateProperties withGeoReplication(DatabasePropertiesGeoReplication geoReplication) {
        super.withGeoReplication(geoReplication);
        return this;
    }

    @Override
    public DatabaseCreateProperties withDeferUpgrade(DeferUpgradeSetting deferUpgrade) {
        super.withDeferUpgrade(deferUpgrade);
        return this;
    }

    @Override
    public DatabaseCreateProperties withAccessKeysAuthentication(AccessKeysAuthentication accessKeysAuthentication) {
        super.withAccessKeysAuthentication(accessKeysAuthentication);
        return this;
    }

    @Override
    public void validate() {
        if (this.persistence() != null) {
            this.persistence().validate();
        }
        if (this.modules() != null) {
            this.modules().forEach(e -> e.validate());
        }
        if (this.geoReplication() != null) {
            this.geoReplication().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientProtocol", this.clientProtocol() == null ? null : this.clientProtocol().toString());
        jsonWriter.writeNumberField("port", (Number)this.port());
        jsonWriter.writeStringField("clusteringPolicy", this.clusteringPolicy() == null ? null : this.clusteringPolicy().toString());
        jsonWriter.writeStringField("evictionPolicy", this.evictionPolicy() == null ? null : this.evictionPolicy().toString());
        jsonWriter.writeJsonField("persistence", (JsonSerializable)this.persistence());
        jsonWriter.writeArrayField("modules", this.modules(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("geoReplication", (JsonSerializable)this.geoReplication());
        jsonWriter.writeStringField("deferUpgrade", this.deferUpgrade() == null ? null : this.deferUpgrade().toString());
        jsonWriter.writeStringField("accessKeysAuthentication", this.accessKeysAuthentication() == null ? null : this.accessKeysAuthentication().toString());
        return jsonWriter.writeEndObject();
    }

    public static DatabaseCreateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseCreateProperties)jsonReader.readObject(reader -> {
            DatabaseCreateProperties deserializedDatabaseCreateProperties = new DatabaseCreateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientProtocol".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.withClientProtocol(Protocol.fromString(reader.getString()));
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.withPort((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.resourceState = ResourceState.fromString(reader.getString());
                    continue;
                }
                if ("clusteringPolicy".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.withClusteringPolicy(ClusteringPolicy.fromString(reader.getString()));
                    continue;
                }
                if ("evictionPolicy".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.withEvictionPolicy(EvictionPolicy.fromString(reader.getString()));
                    continue;
                }
                if ("persistence".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.withPersistence(Persistence.fromJson(reader));
                    continue;
                }
                if ("modules".equals(fieldName)) {
                    List modules = reader.readArray(reader1 -> Module.fromJson(reader1));
                    deserializedDatabaseCreateProperties.withModules(modules);
                    continue;
                }
                if ("geoReplication".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.withGeoReplication(DatabasePropertiesGeoReplication.fromJson(reader));
                    continue;
                }
                if ("redisVersion".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.redisVersion = reader.getString();
                    continue;
                }
                if ("deferUpgrade".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.withDeferUpgrade(DeferUpgradeSetting.fromString(reader.getString()));
                    continue;
                }
                if ("accessKeysAuthentication".equals(fieldName)) {
                    deserializedDatabaseCreateProperties.withAccessKeysAuthentication(AccessKeysAuthentication.fromString(reader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseCreateProperties;
        });
    }
}

