/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redisenterprise.models.ClusterCommonProperties;
import com.azure.resourcemanager.redisenterprise.models.ClusterPropertiesEncryption;
import com.azure.resourcemanager.redisenterprise.models.HighAvailability;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.PublicNetworkAccess;
import com.azure.resourcemanager.redisenterprise.models.RedundancyMode;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import com.azure.resourcemanager.redisenterprise.models.TlsVersion;
import java.io.IOException;
import java.util.List;

public final class ClusterProperties
extends ClusterCommonProperties {
    private PublicNetworkAccess publicNetworkAccess;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private String redisVersion;
    private ResourceState resourceState;
    private RedundancyMode redundancyMode;
    private ProvisioningState provisioningState;
    private String hostname;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterProperties.class);

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ClusterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    @Override
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public String redisVersion() {
        return this.redisVersion;
    }

    @Override
    public ResourceState resourceState() {
        return this.resourceState;
    }

    @Override
    public RedundancyMode redundancyMode() {
        return this.redundancyMode;
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public ClusterProperties withHighAvailability(HighAvailability highAvailability) {
        super.withHighAvailability(highAvailability);
        return this;
    }

    @Override
    public ClusterProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public ClusterProperties withEncryption(ClusterPropertiesEncryption encryption) {
        super.withEncryption(encryption);
        return this;
    }

    @Override
    public void validate() {
        if (this.publicNetworkAccess() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publicNetworkAccess in model ClusterProperties"));
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("highAvailability", this.highAvailability() == null ? null : this.highAvailability().toString());
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion() == null ? null : this.minimumTlsVersion().toString());
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        return jsonWriter.writeEndObject();
    }

    public static ClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterProperties)jsonReader.readObject(reader -> {
            ClusterProperties deserializedClusterProperties = new ClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("highAvailability".equals(fieldName)) {
                    deserializedClusterProperties.withHighAvailability(HighAvailability.fromString(reader.getString()));
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedClusterProperties.withMinimumTlsVersion(TlsVersion.fromString(reader.getString()));
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedClusterProperties.withEncryption(ClusterPropertiesEncryption.fromJson(reader));
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedClusterProperties.hostname = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("redundancyMode".equals(fieldName)) {
                    deserializedClusterProperties.redundancyMode = RedundancyMode.fromString(reader.getString());
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedClusterProperties.resourceState = ResourceState.fromString(reader.getString());
                    continue;
                }
                if ("redisVersion".equals(fieldName)) {
                    deserializedClusterProperties.redisVersion = reader.getString();
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedClusterProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedClusterProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterProperties;
        });
    }
}

