/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.models.AccessPolicyAssignmentPropertiesUser;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import java.io.IOException;

public final class AccessPolicyAssignmentProperties
implements JsonSerializable<AccessPolicyAssignmentProperties> {
    private ProvisioningState provisioningState;
    private String accessPolicyName;
    private AccessPolicyAssignmentPropertiesUser user;
    private static final ClientLogger LOGGER = new ClientLogger(AccessPolicyAssignmentProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String accessPolicyName() {
        return this.accessPolicyName;
    }

    public AccessPolicyAssignmentProperties withAccessPolicyName(String accessPolicyName) {
        this.accessPolicyName = accessPolicyName;
        return this;
    }

    public AccessPolicyAssignmentPropertiesUser user() {
        return this.user;
    }

    public AccessPolicyAssignmentProperties withUser(AccessPolicyAssignmentPropertiesUser user) {
        this.user = user;
        return this;
    }

    public void validate() {
        if (this.accessPolicyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accessPolicyName in model AccessPolicyAssignmentProperties"));
        }
        if (this.user() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property user in model AccessPolicyAssignmentProperties"));
        }
        this.user().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accessPolicyName", this.accessPolicyName);
        jsonWriter.writeJsonField("user", (JsonSerializable)this.user);
        return jsonWriter.writeEndObject();
    }

    public static AccessPolicyAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AccessPolicyAssignmentProperties)jsonReader.readObject(reader -> {
            AccessPolicyAssignmentProperties deserializedAccessPolicyAssignmentProperties = new AccessPolicyAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessPolicyName".equals(fieldName)) {
                    deserializedAccessPolicyAssignmentProperties.accessPolicyName = reader.getString();
                    continue;
                }
                if ("user".equals(fieldName)) {
                    deserializedAccessPolicyAssignmentProperties.user = AccessPolicyAssignmentPropertiesUser.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAccessPolicyAssignmentProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessPolicyAssignmentProperties;
        });
    }
}

