/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.models.AofFrequency;
import com.azure.resourcemanager.redisenterprise.models.RdbFrequency;
import java.io.IOException;

public final class Persistence
implements JsonSerializable<Persistence> {
    private Boolean aofEnabled;
    private Boolean rdbEnabled;
    private AofFrequency aofFrequency;
    private RdbFrequency rdbFrequency;

    public Boolean aofEnabled() {
        return this.aofEnabled;
    }

    public Persistence withAofEnabled(Boolean aofEnabled) {
        this.aofEnabled = aofEnabled;
        return this;
    }

    public Boolean rdbEnabled() {
        return this.rdbEnabled;
    }

    public Persistence withRdbEnabled(Boolean rdbEnabled) {
        this.rdbEnabled = rdbEnabled;
        return this;
    }

    public AofFrequency aofFrequency() {
        return this.aofFrequency;
    }

    public Persistence withAofFrequency(AofFrequency aofFrequency) {
        this.aofFrequency = aofFrequency;
        return this;
    }

    public RdbFrequency rdbFrequency() {
        return this.rdbFrequency;
    }

    public Persistence withRdbFrequency(RdbFrequency rdbFrequency) {
        this.rdbFrequency = rdbFrequency;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("aofEnabled", this.aofEnabled);
        jsonWriter.writeBooleanField("rdbEnabled", this.rdbEnabled);
        jsonWriter.writeStringField("aofFrequency", this.aofFrequency == null ? null : this.aofFrequency.toString());
        jsonWriter.writeStringField("rdbFrequency", this.rdbFrequency == null ? null : this.rdbFrequency.toString());
        return jsonWriter.writeEndObject();
    }

    public static Persistence fromJson(JsonReader jsonReader) throws IOException {
        return (Persistence)jsonReader.readObject(reader -> {
            Persistence deserializedPersistence = new Persistence();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("aofEnabled".equals(fieldName)) {
                    deserializedPersistence.aofEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("rdbEnabled".equals(fieldName)) {
                    deserializedPersistence.rdbEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("aofFrequency".equals(fieldName)) {
                    deserializedPersistence.aofFrequency = AofFrequency.fromString(reader.getString());
                    continue;
                }
                if ("rdbFrequency".equals(fieldName)) {
                    deserializedPersistence.rdbFrequency = RdbFrequency.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPersistence;
        });
    }
}

