/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Module
implements JsonSerializable<Module> {
    private String name;
    private String args;
    private String version;
    private static final ClientLogger LOGGER = new ClientLogger(Module.class);

    public String name() {
        return this.name;
    }

    public Module withName(String name) {
        this.name = name;
        return this;
    }

    public String args() {
        return this.args;
    }

    public Module withArgs(String args) {
        this.args = args;
        return this;
    }

    public String version() {
        return this.version;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Module"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("args", this.args);
        return jsonWriter.writeEndObject();
    }

    public static Module fromJson(JsonReader jsonReader) throws IOException {
        return (Module)jsonReader.readObject(reader -> {
            Module deserializedModule = new Module();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedModule.name = reader.getString();
                    continue;
                }
                if ("args".equals(fieldName)) {
                    deserializedModule.args = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedModule.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModule;
        });
    }
}

