/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.models.LinkedDatabase;
import java.io.IOException;
import java.util.List;

public final class ForceLinkParametersGeoReplication
implements JsonSerializable<ForceLinkParametersGeoReplication> {
    private String groupNickname;
    private List<LinkedDatabase> linkedDatabases;

    public String groupNickname() {
        return this.groupNickname;
    }

    public ForceLinkParametersGeoReplication withGroupNickname(String groupNickname) {
        this.groupNickname = groupNickname;
        return this;
    }

    public List<LinkedDatabase> linkedDatabases() {
        return this.linkedDatabases;
    }

    public ForceLinkParametersGeoReplication withLinkedDatabases(List<LinkedDatabase> linkedDatabases) {
        this.linkedDatabases = linkedDatabases;
        return this;
    }

    public void validate() {
        if (this.linkedDatabases() != null) {
            this.linkedDatabases().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("groupNickname", this.groupNickname);
        jsonWriter.writeArrayField("linkedDatabases", this.linkedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ForceLinkParametersGeoReplication fromJson(JsonReader jsonReader) throws IOException {
        return (ForceLinkParametersGeoReplication)jsonReader.readObject(reader -> {
            ForceLinkParametersGeoReplication deserializedForceLinkParametersGeoReplication = new ForceLinkParametersGeoReplication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("groupNickname".equals(fieldName)) {
                    deserializedForceLinkParametersGeoReplication.groupNickname = reader.getString();
                    continue;
                }
                if ("linkedDatabases".equals(fieldName)) {
                    List linkedDatabases;
                    deserializedForceLinkParametersGeoReplication.linkedDatabases = linkedDatabases = reader.readArray(reader1 -> LinkedDatabase.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForceLinkParametersGeoReplication;
        });
    }
}

