/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redisenterprise.RedisEnterpriseManager;
import com.azure.resourcemanager.redisenterprise.fluent.OperationsStatusClient;
import com.azure.resourcemanager.redisenterprise.fluent.models.OperationStatusInner;
import com.azure.resourcemanager.redisenterprise.implementation.OperationStatusImpl;
import com.azure.resourcemanager.redisenterprise.models.OperationStatus;
import com.azure.resourcemanager.redisenterprise.models.OperationsStatus;

public final class OperationsStatusImpl
implements OperationsStatus {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsStatusImpl.class);
    private final OperationsStatusClient innerClient;
    private final RedisEnterpriseManager serviceManager;

    public OperationsStatusImpl(OperationsStatusClient innerClient, RedisEnterpriseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OperationStatus> getWithResponse(String location, String operationId, Context context) {
        Response<OperationStatusInner> inner = this.serviceClient().getWithResponse(location, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationStatusImpl((OperationStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationStatus get(String location, String operationId) {
        OperationStatusInner inner = this.serviceClient().get(location, operationId);
        if (inner != null) {
            return new OperationStatusImpl(inner, this.manager());
        }
        return null;
    }

    private OperationsStatusClient serviceClient() {
        return this.innerClient;
    }

    private RedisEnterpriseManager manager() {
        return this.serviceManager;
    }
}

