/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.models.AccessKeysAuthentication;
import com.azure.resourcemanager.redisenterprise.models.ClusteringPolicy;
import com.azure.resourcemanager.redisenterprise.models.DatabasePropertiesGeoReplication;
import com.azure.resourcemanager.redisenterprise.models.DeferUpgradeSetting;
import com.azure.resourcemanager.redisenterprise.models.EvictionPolicy;
import com.azure.resourcemanager.redisenterprise.models.Module;
import com.azure.resourcemanager.redisenterprise.models.Persistence;
import com.azure.resourcemanager.redisenterprise.models.Protocol;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import java.io.IOException;
import java.util.List;

public final class DatabaseProperties
implements JsonSerializable<DatabaseProperties> {
    private Protocol clientProtocol;
    private Integer port;
    private ProvisioningState provisioningState;
    private ResourceState resourceState;
    private ClusteringPolicy clusteringPolicy;
    private EvictionPolicy evictionPolicy;
    private Persistence persistence;
    private List<Module> modules;
    private DatabasePropertiesGeoReplication geoReplication;
    private String redisVersion;
    private DeferUpgradeSetting deferUpgrade;
    private AccessKeysAuthentication accessKeysAuthentication;

    public Protocol clientProtocol() {
        return this.clientProtocol;
    }

    public DatabaseProperties withClientProtocol(Protocol clientProtocol) {
        this.clientProtocol = clientProtocol;
        return this;
    }

    public Integer port() {
        return this.port;
    }

    public DatabaseProperties withPort(Integer port) {
        this.port = port;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ResourceState resourceState() {
        return this.resourceState;
    }

    public ClusteringPolicy clusteringPolicy() {
        return this.clusteringPolicy;
    }

    public DatabaseProperties withClusteringPolicy(ClusteringPolicy clusteringPolicy) {
        this.clusteringPolicy = clusteringPolicy;
        return this;
    }

    public EvictionPolicy evictionPolicy() {
        return this.evictionPolicy;
    }

    public DatabaseProperties withEvictionPolicy(EvictionPolicy evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public Persistence persistence() {
        return this.persistence;
    }

    public DatabaseProperties withPersistence(Persistence persistence) {
        this.persistence = persistence;
        return this;
    }

    public List<Module> modules() {
        return this.modules;
    }

    public DatabaseProperties withModules(List<Module> modules) {
        this.modules = modules;
        return this;
    }

    public DatabasePropertiesGeoReplication geoReplication() {
        return this.geoReplication;
    }

    public DatabaseProperties withGeoReplication(DatabasePropertiesGeoReplication geoReplication) {
        this.geoReplication = geoReplication;
        return this;
    }

    public String redisVersion() {
        return this.redisVersion;
    }

    public DeferUpgradeSetting deferUpgrade() {
        return this.deferUpgrade;
    }

    public DatabaseProperties withDeferUpgrade(DeferUpgradeSetting deferUpgrade) {
        this.deferUpgrade = deferUpgrade;
        return this;
    }

    public AccessKeysAuthentication accessKeysAuthentication() {
        return this.accessKeysAuthentication;
    }

    public DatabaseProperties withAccessKeysAuthentication(AccessKeysAuthentication accessKeysAuthentication) {
        this.accessKeysAuthentication = accessKeysAuthentication;
        return this;
    }

    public void validate() {
        if (this.persistence() != null) {
            this.persistence().validate();
        }
        if (this.modules() != null) {
            this.modules().forEach(e -> e.validate());
        }
        if (this.geoReplication() != null) {
            this.geoReplication().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientProtocol", this.clientProtocol == null ? null : this.clientProtocol.toString());
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeStringField("clusteringPolicy", this.clusteringPolicy == null ? null : this.clusteringPolicy.toString());
        jsonWriter.writeStringField("evictionPolicy", this.evictionPolicy == null ? null : this.evictionPolicy.toString());
        jsonWriter.writeJsonField("persistence", (JsonSerializable)this.persistence);
        jsonWriter.writeArrayField("modules", this.modules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("geoReplication", (JsonSerializable)this.geoReplication);
        jsonWriter.writeStringField("deferUpgrade", this.deferUpgrade == null ? null : this.deferUpgrade.toString());
        jsonWriter.writeStringField("accessKeysAuthentication", this.accessKeysAuthentication == null ? null : this.accessKeysAuthentication.toString());
        return jsonWriter.writeEndObject();
    }

    public static DatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseProperties)jsonReader.readObject(reader -> {
            DatabaseProperties deserializedDatabaseProperties = new DatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientProtocol".equals(fieldName)) {
                    deserializedDatabaseProperties.clientProtocol = Protocol.fromString(reader.getString());
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedDatabaseProperties.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabaseProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedDatabaseProperties.resourceState = ResourceState.fromString(reader.getString());
                    continue;
                }
                if ("clusteringPolicy".equals(fieldName)) {
                    deserializedDatabaseProperties.clusteringPolicy = ClusteringPolicy.fromString(reader.getString());
                    continue;
                }
                if ("evictionPolicy".equals(fieldName)) {
                    deserializedDatabaseProperties.evictionPolicy = EvictionPolicy.fromString(reader.getString());
                    continue;
                }
                if ("persistence".equals(fieldName)) {
                    deserializedDatabaseProperties.persistence = Persistence.fromJson(reader);
                    continue;
                }
                if ("modules".equals(fieldName)) {
                    List modules;
                    deserializedDatabaseProperties.modules = modules = reader.readArray(reader1 -> Module.fromJson(reader1));
                    continue;
                }
                if ("geoReplication".equals(fieldName)) {
                    deserializedDatabaseProperties.geoReplication = DatabasePropertiesGeoReplication.fromJson(reader);
                    continue;
                }
                if ("redisVersion".equals(fieldName)) {
                    deserializedDatabaseProperties.redisVersion = reader.getString();
                    continue;
                }
                if ("deferUpgrade".equals(fieldName)) {
                    deserializedDatabaseProperties.deferUpgrade = DeferUpgradeSetting.fromString(reader.getString());
                    continue;
                }
                if ("accessKeysAuthentication".equals(fieldName)) {
                    deserializedDatabaseProperties.accessKeysAuthentication = AccessKeysAuthentication.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseProperties;
        });
    }
}

