/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redisenterprise.models.ClusterPropertiesEncryption;
import com.azure.resourcemanager.redisenterprise.models.HighAvailability;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.RedundancyMode;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import com.azure.resourcemanager.redisenterprise.models.TlsVersion;
import java.io.IOException;
import java.util.List;

public final class ClusterProperties
implements JsonSerializable<ClusterProperties> {
    private HighAvailability highAvailability;
    private TlsVersion minimumTlsVersion;
    private ClusterPropertiesEncryption encryption;
    private String hostname;
    private ProvisioningState provisioningState;
    private RedundancyMode redundancyMode;
    private ResourceState resourceState;
    private String redisVersion;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    public HighAvailability highAvailability() {
        return this.highAvailability;
    }

    public ClusterProperties withHighAvailability(HighAvailability highAvailability) {
        this.highAvailability = highAvailability;
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public ClusterProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public ClusterPropertiesEncryption encryption() {
        return this.encryption;
    }

    public ClusterProperties withEncryption(ClusterPropertiesEncryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public RedundancyMode redundancyMode() {
        return this.redundancyMode;
    }

    public ResourceState resourceState() {
        return this.resourceState;
    }

    public String redisVersion() {
        return this.redisVersion;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public void validate() {
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("highAvailability", this.highAvailability == null ? null : this.highAvailability.toString());
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion == null ? null : this.minimumTlsVersion.toString());
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        return jsonWriter.writeEndObject();
    }

    public static ClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterProperties)jsonReader.readObject(reader -> {
            ClusterProperties deserializedClusterProperties = new ClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("highAvailability".equals(fieldName)) {
                    deserializedClusterProperties.highAvailability = HighAvailability.fromString(reader.getString());
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedClusterProperties.minimumTlsVersion = TlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedClusterProperties.encryption = ClusterPropertiesEncryption.fromJson(reader);
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedClusterProperties.hostname = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("redundancyMode".equals(fieldName)) {
                    deserializedClusterProperties.redundancyMode = RedundancyMode.fromString(reader.getString());
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedClusterProperties.resourceState = ResourceState.fromString(reader.getString());
                    continue;
                }
                if ("redisVersion".equals(fieldName)) {
                    deserializedClusterProperties.redisVersion = reader.getString();
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedClusterProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterProperties;
        });
    }
}

