/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redisenterprise.fluent.models.ClusterProperties;
import com.azure.resourcemanager.redisenterprise.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redisenterprise.models.ClusterPropertiesEncryption;
import com.azure.resourcemanager.redisenterprise.models.HighAvailability;
import com.azure.resourcemanager.redisenterprise.models.Kind;
import com.azure.resourcemanager.redisenterprise.models.ManagedServiceIdentity;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.RedundancyMode;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import com.azure.resourcemanager.redisenterprise.models.Sku;
import com.azure.resourcemanager.redisenterprise.models.TlsVersion;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ClusterInner
extends Resource {
    private Kind kind;
    private Sku sku;
    private List<String> zones;
    private ManagedServiceIdentity identity;
    private ClusterProperties innerProperties;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterInner.class);

    public Kind kind() {
        return this.kind;
    }

    public Sku sku() {
        return this.sku;
    }

    public ClusterInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public ClusterInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ClusterInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ClusterProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public HighAvailability highAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailability();
    }

    public ClusterInner withHighAvailability(HighAvailability highAvailability) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withHighAvailability(highAvailability);
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    public ClusterInner withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    public ClusterPropertiesEncryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public ClusterInner withEncryption(ClusterPropertiesEncryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public RedundancyMode redundancyMode() {
        return this.innerProperties() == null ? null : this.innerProperties().redundancyMode();
    }

    public ResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public String redisVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().redisVersion();
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model ClusterInner"));
        }
        this.sku().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ClusterInner fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterInner)((Object)jsonReader.readObject(reader -> {
            ClusterInner deserializedClusterInner = new ClusterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClusterInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedClusterInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedClusterInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedClusterInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedClusterInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedClusterInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedClusterInner.kind = Kind.fromString(reader.getString());
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedClusterInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedClusterInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedClusterInner.innerProperties = ClusterProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterInner;
        }));
    }
}

