/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.implementation;

import com.azure.resourcemanager.redis.RedisManager;
import com.azure.resourcemanager.redis.fluent.RedisManagementClient;
import com.azure.resourcemanager.redis.fluent.models.RedisFirewallRuleInner;
import com.azure.resourcemanager.redis.implementation.RedisCacheImpl;
import com.azure.resourcemanager.redis.implementation.RedisFirewallRuleImpl;
import com.azure.resourcemanager.redis.models.RedisCache;
import com.azure.resourcemanager.redis.models.RedisFirewallRule;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RedisFirewallRulesImpl
extends ExternalChildResourcesCachedImpl<RedisFirewallRuleImpl, RedisFirewallRule, RedisFirewallRuleInner, RedisCacheImpl, RedisCache> {
    private boolean load = false;

    RedisFirewallRulesImpl(RedisCacheImpl parent) {
        super((Object)parent, parent.taskGroup(), "FirewallRule");
    }

    void ensureCollectionLoaded() {
        if (!this.load) {
            this.load = true;
            this.cacheCollection();
        }
    }

    Map<String, RedisFirewallRule> rulesAsMap() {
        this.ensureCollectionLoaded();
        HashMap<String, RedisFirewallRuleImpl> result = new HashMap<String, RedisFirewallRuleImpl>();
        for (Map.Entry entry : this.collection().entrySet()) {
            RedisFirewallRuleImpl endpoint = (RedisFirewallRuleImpl)entry.getValue();
            result.put((String)entry.getKey(), endpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    public void addRule(RedisFirewallRuleImpl rule) {
        this.ensureCollectionLoaded();
        this.addChildResource(rule);
    }

    public void removeRule(String name) {
        this.ensureCollectionLoaded();
        this.prepareInlineRemove(name);
    }

    public RedisFirewallRuleImpl defineInlineFirewallRule(String name) {
        this.ensureCollectionLoaded();
        return (RedisFirewallRuleImpl)this.prepareInlineDefine(name);
    }

    protected Flux<RedisFirewallRuleImpl> listChildResourcesAsync() {
        return ((RedisManagementClient)((RedisManager)((RedisCacheImpl)this.getParent()).manager()).serviceClient()).getFirewallRules().listAsync(((RedisCacheImpl)this.getParent()).resourceGroupName(), ((RedisCacheImpl)this.getParent()).name()).map(firewallRuleInner -> new RedisFirewallRuleImpl(firewallRuleInner.name(), (RedisCacheImpl)this.getParent(), (RedisFirewallRuleInner)((Object)firewallRuleInner))).onErrorResume(e -> Mono.empty());
    }

    protected List<RedisFirewallRuleImpl> listChildResources() {
        return (List)this.listChildResourcesAsync().collectList().block();
    }

    protected RedisFirewallRuleImpl newChildResource(String name) {
        return new RedisFirewallRuleImpl(name, (RedisCacheImpl)this.getParent(), new RedisFirewallRuleInner());
    }
}

