/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redis.fluent.models.RedisAccessKeysInner;
import com.azure.resourcemanager.redis.fluent.models.RedisCreateProperties;
import com.azure.resourcemanager.redis.models.ProvisioningState;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.azure.resourcemanager.redis.models.RedisInstanceDetails;
import com.azure.resourcemanager.redis.models.RedisLinkedServer;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.azure.resourcemanager.redis.models.UpdateChannel;
import com.azure.resourcemanager.redis.models.ZonalAllocationPolicy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class RedisPropertiesInner
extends RedisCreateProperties {
    private ProvisioningState provisioningState;
    private String hostname;
    private Integer port;
    private Integer sslPort;
    private RedisAccessKeysInner accessKeys;
    private List<RedisLinkedServer> linkedServers;
    private List<RedisInstanceDetails> instances;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private static final ClientLogger LOGGER = new ClientLogger(RedisPropertiesInner.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String hostname() {
        return this.hostname;
    }

    public Integer port() {
        return this.port;
    }

    public Integer sslPort() {
        return this.sslPort;
    }

    public RedisAccessKeysInner accessKeys() {
        return this.accessKeys;
    }

    public List<RedisLinkedServer> linkedServers() {
        return this.linkedServers;
    }

    public List<RedisInstanceDetails> instances() {
        return this.instances;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public RedisPropertiesInner withSku(Sku sku) {
        super.withSku(sku);
        return this;
    }

    @Override
    public RedisPropertiesInner withSubnetId(String subnetId) {
        super.withSubnetId(subnetId);
        return this;
    }

    @Override
    public RedisPropertiesInner withStaticIp(String staticIp) {
        super.withStaticIp(staticIp);
        return this;
    }

    @Override
    public RedisPropertiesInner withRedisConfiguration(RedisConfiguration redisConfiguration) {
        super.withRedisConfiguration(redisConfiguration);
        return this;
    }

    @Override
    public RedisPropertiesInner withRedisVersion(String redisVersion) {
        super.withRedisVersion(redisVersion);
        return this;
    }

    @Override
    public RedisPropertiesInner withEnableNonSslPort(Boolean enableNonSslPort) {
        super.withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    @Override
    public RedisPropertiesInner withReplicasPerMaster(Integer replicasPerMaster) {
        super.withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    @Override
    public RedisPropertiesInner withReplicasPerPrimary(Integer replicasPerPrimary) {
        super.withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    @Override
    public RedisPropertiesInner withTenantSettings(Map<String, String> tenantSettings) {
        super.withTenantSettings((Map)tenantSettings);
        return this;
    }

    @Override
    public RedisPropertiesInner withShardCount(Integer shardCount) {
        super.withShardCount(shardCount);
        return this;
    }

    @Override
    public RedisPropertiesInner withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public RedisPropertiesInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public RedisPropertiesInner withUpdateChannel(UpdateChannel updateChannel) {
        super.withUpdateChannel(updateChannel);
        return this;
    }

    @Override
    public RedisPropertiesInner withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        super.withDisableAccessKeyAuthentication(disableAccessKeyAuthentication);
        return this;
    }

    @Override
    public RedisPropertiesInner withZonalAllocationPolicy(ZonalAllocationPolicy zonalAllocationPolicy) {
        super.withZonalAllocationPolicy(zonalAllocationPolicy);
        return this;
    }

    @Override
    public void validate() {
        if (this.accessKeys() != null) {
            this.accessKeys().validate();
        }
        if (this.linkedServers() != null) {
            this.linkedServers().forEach(e -> e.validate());
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.redisConfiguration() != null) {
            this.redisConfiguration().validate();
        }
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model RedisPropertiesInner"));
        }
        this.sku().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku());
        jsonWriter.writeJsonField("redisConfiguration", (JsonSerializable)this.redisConfiguration());
        jsonWriter.writeStringField("redisVersion", this.redisVersion());
        jsonWriter.writeBooleanField("enableNonSslPort", this.enableNonSslPort());
        jsonWriter.writeNumberField("replicasPerMaster", (Number)this.replicasPerMaster());
        jsonWriter.writeNumberField("replicasPerPrimary", (Number)this.replicasPerPrimary());
        jsonWriter.writeMapField("tenantSettings", this.tenantSettings(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("shardCount", (Number)this.shardCount());
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion() == null ? null : this.minimumTlsVersion().toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess() == null ? null : this.publicNetworkAccess().toString());
        jsonWriter.writeStringField("updateChannel", this.updateChannel() == null ? null : this.updateChannel().toString());
        jsonWriter.writeBooleanField("disableAccessKeyAuthentication", this.disableAccessKeyAuthentication());
        jsonWriter.writeStringField("zonalAllocationPolicy", this.zonalAllocationPolicy() == null ? null : this.zonalAllocationPolicy().toString());
        jsonWriter.writeStringField("subnetId", this.subnetId());
        jsonWriter.writeStringField("staticIP", this.staticIp());
        return jsonWriter.writeEndObject();
    }

    public static RedisPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (RedisPropertiesInner)jsonReader.readObject(reader -> {
            RedisPropertiesInner deserializedRedisPropertiesInner = new RedisPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withSku(Sku.fromJson(reader));
                    continue;
                }
                if ("redisConfiguration".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withRedisConfiguration(RedisConfiguration.fromJson(reader));
                    continue;
                }
                if ("redisVersion".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withRedisVersion(reader.getString());
                    continue;
                }
                if ("enableNonSslPort".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withEnableNonSslPort((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("replicasPerMaster".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withReplicasPerMaster((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("replicasPerPrimary".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withReplicasPerPrimary((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("tenantSettings".equals(fieldName)) {
                    Map tenantSettings = reader.readMap(reader1 -> reader1.getString());
                    deserializedRedisPropertiesInner.withTenantSettings(tenantSettings);
                    continue;
                }
                if ("shardCount".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withShardCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withMinimumTlsVersion(TlsVersion.fromString(reader.getString()));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withPublicNetworkAccess(PublicNetworkAccess.fromString(reader.getString()));
                    continue;
                }
                if ("updateChannel".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withUpdateChannel(UpdateChannel.fromString(reader.getString()));
                    continue;
                }
                if ("disableAccessKeyAuthentication".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withDisableAccessKeyAuthentication((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("zonalAllocationPolicy".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withZonalAllocationPolicy(ZonalAllocationPolicy.fromString(reader.getString()));
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withSubnetId(reader.getString());
                    continue;
                }
                if ("staticIP".equals(fieldName)) {
                    deserializedRedisPropertiesInner.withStaticIp(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRedisPropertiesInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedRedisPropertiesInner.hostname = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedRedisPropertiesInner.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sslPort".equals(fieldName)) {
                    deserializedRedisPropertiesInner.sslPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("accessKeys".equals(fieldName)) {
                    deserializedRedisPropertiesInner.accessKeys = RedisAccessKeysInner.fromJson(reader);
                    continue;
                }
                if ("linkedServers".equals(fieldName)) {
                    List linkedServers;
                    deserializedRedisPropertiesInner.linkedServers = linkedServers = reader.readArray(reader1 -> RedisLinkedServer.fromJson(reader1));
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List instances;
                    deserializedRedisPropertiesInner.instances = instances = reader.readArray(reader1 -> RedisInstanceDetails.fromJson(reader1));
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedRedisPropertiesInner.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisPropertiesInner;
        });
    }
}

