/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.AvsDiskDetails;
import com.azure.resourcemanager.purestorageblock.models.ResourceProvisioningState;
import com.azure.resourcemanager.purestorageblock.models.SoftDeletion;
import com.azure.resourcemanager.purestorageblock.models.Space;
import com.azure.resourcemanager.purestorageblock.models.VolumeType;
import java.io.IOException;

public final class VolumeProperties
implements JsonSerializable<VolumeProperties> {
    private String storagePoolInternalId;
    private String storagePoolResourceId;
    private String volumeInternalId;
    private String displayName;
    private Space space;
    private SoftDeletion softDeletion;
    private String createdTimestamp;
    private Long provisionedSize;
    private VolumeType volumeType;
    private AvsDiskDetails avs;
    private ResourceProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(VolumeProperties.class);

    private VolumeProperties() {
    }

    public String storagePoolInternalId() {
        return this.storagePoolInternalId;
    }

    public String storagePoolResourceId() {
        return this.storagePoolResourceId;
    }

    public String volumeInternalId() {
        return this.volumeInternalId;
    }

    public String displayName() {
        return this.displayName;
    }

    public Space space() {
        return this.space;
    }

    public SoftDeletion softDeletion() {
        return this.softDeletion;
    }

    public String createdTimestamp() {
        return this.createdTimestamp;
    }

    public Long provisionedSize() {
        return this.provisionedSize;
    }

    public VolumeType volumeType() {
        return this.volumeType;
    }

    public AvsDiskDetails avs() {
        return this.avs;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.space() != null) {
            this.space().validate();
        }
        if (this.softDeletion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property softDeletion in model VolumeProperties"));
        }
        this.softDeletion().validate();
        if (this.avs() != null) {
            this.avs().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("softDeletion", (JsonSerializable)this.softDeletion);
        return jsonWriter.writeEndObject();
    }

    public static VolumeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeProperties)jsonReader.readObject(reader -> {
            VolumeProperties deserializedVolumeProperties = new VolumeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("softDeletion".equals(fieldName)) {
                    deserializedVolumeProperties.softDeletion = SoftDeletion.fromJson(reader);
                    continue;
                }
                if ("storagePoolInternalId".equals(fieldName)) {
                    deserializedVolumeProperties.storagePoolInternalId = reader.getString();
                    continue;
                }
                if ("storagePoolResourceId".equals(fieldName)) {
                    deserializedVolumeProperties.storagePoolResourceId = reader.getString();
                    continue;
                }
                if ("volumeInternalId".equals(fieldName)) {
                    deserializedVolumeProperties.volumeInternalId = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedVolumeProperties.displayName = reader.getString();
                    continue;
                }
                if ("space".equals(fieldName)) {
                    deserializedVolumeProperties.space = Space.fromJson(reader);
                    continue;
                }
                if ("createdTimestamp".equals(fieldName)) {
                    deserializedVolumeProperties.createdTimestamp = reader.getString();
                    continue;
                }
                if ("provisionedSize".equals(fieldName)) {
                    deserializedVolumeProperties.provisionedSize = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("volumeType".equals(fieldName)) {
                    deserializedVolumeProperties.volumeType = VolumeType.fromString(reader.getString());
                    continue;
                }
                if ("avs".equals(fieldName)) {
                    deserializedVolumeProperties.avs = AvsDiskDetails.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVolumeProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeProperties;
        });
    }
}

