/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VnetInjection
implements JsonSerializable<VnetInjection> {
    private String subnetId;
    private String vnetId;
    private static final ClientLogger LOGGER = new ClientLogger(VnetInjection.class);

    public String subnetId() {
        return this.subnetId;
    }

    public VnetInjection withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String vnetId() {
        return this.vnetId;
    }

    public VnetInjection withVnetId(String vnetId) {
        this.vnetId = vnetId;
        return this;
    }

    public void validate() {
        if (this.subnetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnetId in model VnetInjection"));
        }
        if (this.vnetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vnetId in model VnetInjection"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("vnetId", this.vnetId);
        return jsonWriter.writeEndObject();
    }

    public static VnetInjection fromJson(JsonReader jsonReader) throws IOException {
        return (VnetInjection)jsonReader.readObject(reader -> {
            VnetInjection deserializedVnetInjection = new VnetInjection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnetId".equals(fieldName)) {
                    deserializedVnetInjection.subnetId = reader.getString();
                    continue;
                }
                if ("vnetId".equals(fieldName)) {
                    deserializedVnetInjection.vnetId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVnetInjection;
        });
    }
}

