/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.CompanyDetails;
import java.io.IOException;

public final class UserDetails
implements JsonSerializable<UserDetails> {
    private String firstName;
    private String lastName;
    private String emailAddress;
    private String upn;
    private String phoneNumber;
    private CompanyDetails companyDetails;
    private static final ClientLogger LOGGER = new ClientLogger(UserDetails.class);

    public String firstName() {
        return this.firstName;
    }

    public UserDetails withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return this.lastName;
    }

    public UserDetails withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public UserDetails withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    public String upn() {
        return this.upn;
    }

    public UserDetails withUpn(String upn) {
        this.upn = upn;
        return this;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public UserDetails withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public CompanyDetails companyDetails() {
        return this.companyDetails;
    }

    public UserDetails withCompanyDetails(CompanyDetails companyDetails) {
        this.companyDetails = companyDetails;
        return this;
    }

    public void validate() {
        if (this.firstName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property firstName in model UserDetails"));
        }
        if (this.lastName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property lastName in model UserDetails"));
        }
        if (this.emailAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property emailAddress in model UserDetails"));
        }
        if (this.companyDetails() != null) {
            this.companyDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("firstName", this.firstName);
        jsonWriter.writeStringField("lastName", this.lastName);
        jsonWriter.writeStringField("emailAddress", this.emailAddress);
        jsonWriter.writeStringField("upn", this.upn);
        jsonWriter.writeStringField("phoneNumber", this.phoneNumber);
        jsonWriter.writeJsonField("companyDetails", (JsonSerializable)this.companyDetails);
        return jsonWriter.writeEndObject();
    }

    public static UserDetails fromJson(JsonReader jsonReader) throws IOException {
        return (UserDetails)jsonReader.readObject(reader -> {
            UserDetails deserializedUserDetails = new UserDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("firstName".equals(fieldName)) {
                    deserializedUserDetails.firstName = reader.getString();
                    continue;
                }
                if ("lastName".equals(fieldName)) {
                    deserializedUserDetails.lastName = reader.getString();
                    continue;
                }
                if ("emailAddress".equals(fieldName)) {
                    deserializedUserDetails.emailAddress = reader.getString();
                    continue;
                }
                if ("upn".equals(fieldName)) {
                    deserializedUserDetails.upn = reader.getString();
                    continue;
                }
                if ("phoneNumber".equals(fieldName)) {
                    deserializedUserDetails.phoneNumber = reader.getString();
                    continue;
                }
                if ("companyDetails".equals(fieldName)) {
                    deserializedUserDetails.companyDetails = CompanyDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserDetails;
        });
    }
}

