/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.AzureVmwareService;
import com.azure.resourcemanager.purestorageblock.models.ProvisioningState;
import com.azure.resourcemanager.purestorageblock.models.VnetInjection;
import java.io.IOException;

public final class StoragePoolProperties
implements JsonSerializable<StoragePoolProperties> {
    private String storagePoolInternalId;
    private String availabilityZone;
    private VnetInjection vnetInjection;
    private Long dataRetentionPeriod;
    private long provisionedBandwidthMbPerSec;
    private Long provisionedIops;
    private AzureVmwareService avs;
    private ProvisioningState provisioningState;
    private String reservationResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(StoragePoolProperties.class);

    public String storagePoolInternalId() {
        return this.storagePoolInternalId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public StoragePoolProperties withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public VnetInjection vnetInjection() {
        return this.vnetInjection;
    }

    public StoragePoolProperties withVnetInjection(VnetInjection vnetInjection) {
        this.vnetInjection = vnetInjection;
        return this;
    }

    public Long dataRetentionPeriod() {
        return this.dataRetentionPeriod;
    }

    public long provisionedBandwidthMbPerSec() {
        return this.provisionedBandwidthMbPerSec;
    }

    public StoragePoolProperties withProvisionedBandwidthMbPerSec(long provisionedBandwidthMbPerSec) {
        this.provisionedBandwidthMbPerSec = provisionedBandwidthMbPerSec;
        return this;
    }

    public Long provisionedIops() {
        return this.provisionedIops;
    }

    public AzureVmwareService avs() {
        return this.avs;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String reservationResourceId() {
        return this.reservationResourceId;
    }

    public StoragePoolProperties withReservationResourceId(String reservationResourceId) {
        this.reservationResourceId = reservationResourceId;
        return this;
    }

    public void validate() {
        if (this.availabilityZone() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property availabilityZone in model StoragePoolProperties"));
        }
        if (this.vnetInjection() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vnetInjection in model StoragePoolProperties"));
        }
        this.vnetInjection().validate();
        if (this.avs() != null) {
            this.avs().validate();
        }
        if (this.reservationResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property reservationResourceId in model StoragePoolProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("availabilityZone", this.availabilityZone);
        jsonWriter.writeJsonField("vnetInjection", (JsonSerializable)this.vnetInjection);
        jsonWriter.writeLongField("provisionedBandwidthMbPerSec", this.provisionedBandwidthMbPerSec);
        jsonWriter.writeStringField("reservationResourceId", this.reservationResourceId);
        return jsonWriter.writeEndObject();
    }

    public static StoragePoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StoragePoolProperties)jsonReader.readObject(reader -> {
            StoragePoolProperties deserializedStoragePoolProperties = new StoragePoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("availabilityZone".equals(fieldName)) {
                    deserializedStoragePoolProperties.availabilityZone = reader.getString();
                    continue;
                }
                if ("vnetInjection".equals(fieldName)) {
                    deserializedStoragePoolProperties.vnetInjection = VnetInjection.fromJson(reader);
                    continue;
                }
                if ("provisionedBandwidthMbPerSec".equals(fieldName)) {
                    deserializedStoragePoolProperties.provisionedBandwidthMbPerSec = reader.getLong();
                    continue;
                }
                if ("reservationResourceId".equals(fieldName)) {
                    deserializedStoragePoolProperties.reservationResourceId = reader.getString();
                    continue;
                }
                if ("storagePoolInternalId".equals(fieldName)) {
                    deserializedStoragePoolProperties.storagePoolInternalId = reader.getString();
                    continue;
                }
                if ("dataRetentionPeriod".equals(fieldName)) {
                    deserializedStoragePoolProperties.dataRetentionPeriod = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("provisionedIops".equals(fieldName)) {
                    deserializedStoragePoolProperties.provisionedIops = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("avs".equals(fieldName)) {
                    deserializedStoragePoolProperties.avs = AzureVmwareService.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedStoragePoolProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStoragePoolProperties;
        });
    }
}

