/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.RangeLimits;
import java.io.IOException;
import java.util.List;

public final class StoragePoolLimits
implements JsonSerializable<StoragePoolLimits> {
    private RangeLimits provisionedBandwidthMbPerSec;
    private RangeLimits provisionedIops;
    private List<String> physicalAvailabilityZones;
    private static final ClientLogger LOGGER = new ClientLogger(StoragePoolLimits.class);

    private StoragePoolLimits() {
    }

    public RangeLimits provisionedBandwidthMbPerSec() {
        return this.provisionedBandwidthMbPerSec;
    }

    public RangeLimits provisionedIops() {
        return this.provisionedIops;
    }

    public List<String> physicalAvailabilityZones() {
        return this.physicalAvailabilityZones;
    }

    public void validate() {
        if (this.provisionedBandwidthMbPerSec() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property provisionedBandwidthMbPerSec in model StoragePoolLimits"));
        }
        this.provisionedBandwidthMbPerSec().validate();
        if (this.provisionedIops() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property provisionedIops in model StoragePoolLimits"));
        }
        this.provisionedIops().validate();
        if (this.physicalAvailabilityZones() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property physicalAvailabilityZones in model StoragePoolLimits"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("provisionedBandwidthMbPerSec", (JsonSerializable)this.provisionedBandwidthMbPerSec);
        jsonWriter.writeJsonField("provisionedIops", (JsonSerializable)this.provisionedIops);
        jsonWriter.writeArrayField("physicalAvailabilityZones", this.physicalAvailabilityZones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StoragePoolLimits fromJson(JsonReader jsonReader) throws IOException {
        return (StoragePoolLimits)jsonReader.readObject(reader -> {
            StoragePoolLimits deserializedStoragePoolLimits = new StoragePoolLimits();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisionedBandwidthMbPerSec".equals(fieldName)) {
                    deserializedStoragePoolLimits.provisionedBandwidthMbPerSec = RangeLimits.fromJson(reader);
                    continue;
                }
                if ("provisionedIops".equals(fieldName)) {
                    deserializedStoragePoolLimits.provisionedIops = RangeLimits.fromJson(reader);
                    continue;
                }
                if ("physicalAvailabilityZones".equals(fieldName)) {
                    List physicalAvailabilityZones;
                    deserializedStoragePoolLimits.physicalAvailabilityZones = physicalAvailabilityZones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStoragePoolLimits;
        });
    }
}

