/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.purestorageblock.fluent.models.StoragePoolInner;
import com.azure.resourcemanager.purestorageblock.models.AvsConnection;
import com.azure.resourcemanager.purestorageblock.models.AvsStatus;
import com.azure.resourcemanager.purestorageblock.models.ManagedServiceIdentity;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolEnableAvsConnectionPost;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolFinalizeAvsConnectionPost;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolHealthInfo;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolProperties;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolUpdateProperties;
import java.util.Map;

public interface StoragePool {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public StoragePoolProperties properties();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public StoragePoolInner innerModel();

    public Update update();

    public StoragePool refresh();

    public StoragePool refresh(Context var1);

    public Response<StoragePoolHealthInfo> getHealthStatusWithResponse(Context var1);

    public StoragePoolHealthInfo getHealthStatus();

    public Response<AvsConnection> getAvsConnectionWithResponse(Context var1);

    public AvsConnection getAvsConnection();

    public Response<AvsStatus> getAvsStatusWithResponse(Context var1);

    public AvsStatus getAvsStatus();

    public void enableAvsConnection(StoragePoolEnableAvsConnectionPost var1);

    public void enableAvsConnection(StoragePoolEnableAvsConnectionPost var1, Context var2);

    public void disableAvsConnection();

    public void disableAvsConnection(Context var1);

    public void finalizeAvsConnection(StoragePoolFinalizeAvsConnectionPost var1);

    public void finalizeAvsConnection(StoragePoolFinalizeAvsConnectionPost var1, Context var2);

    public void repairAvsConnection();

    public void repairAvsConnection(Context var1);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(StoragePoolUpdateProperties var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithProperties {
        public StoragePool apply();

        public StoragePool apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(StoragePoolProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties,
        WithIdentity {
            public StoragePool create();

            public StoragePool create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

