/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.ReservationUpdateProperties;
import java.io.IOException;
import java.util.Map;

public final class ReservationUpdate
implements JsonSerializable<ReservationUpdate> {
    private Map<String, String> tags;
    private ReservationUpdateProperties properties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public ReservationUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ReservationUpdateProperties properties() {
        return this.properties;
    }

    public ReservationUpdate withProperties(ReservationUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ReservationUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ReservationUpdate)jsonReader.readObject(reader -> {
            ReservationUpdate deserializedReservationUpdate = new ReservationUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedReservationUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedReservationUpdate.properties = ReservationUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReservationUpdate;
        });
    }
}

