/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.MarketplaceDetails;
import com.azure.resourcemanager.purestorageblock.models.ProvisioningState;
import com.azure.resourcemanager.purestorageblock.models.UserDetails;
import java.io.IOException;

public final class ReservationPropertiesBaseResourceProperties
implements JsonSerializable<ReservationPropertiesBaseResourceProperties> {
    private String reservationInternalId;
    private MarketplaceDetails marketplace;
    private UserDetails user;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ReservationPropertiesBaseResourceProperties.class);

    public String reservationInternalId() {
        return this.reservationInternalId;
    }

    public MarketplaceDetails marketplace() {
        return this.marketplace;
    }

    public ReservationPropertiesBaseResourceProperties withMarketplace(MarketplaceDetails marketplace) {
        this.marketplace = marketplace;
        return this;
    }

    public UserDetails user() {
        return this.user;
    }

    public ReservationPropertiesBaseResourceProperties withUser(UserDetails user) {
        this.user = user;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.marketplace() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property marketplace in model ReservationPropertiesBaseResourceProperties"));
        }
        this.marketplace().validate();
        if (this.user() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property user in model ReservationPropertiesBaseResourceProperties"));
        }
        this.user().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("marketplace", (JsonSerializable)this.marketplace);
        jsonWriter.writeJsonField("user", (JsonSerializable)this.user);
        return jsonWriter.writeEndObject();
    }

    public static ReservationPropertiesBaseResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ReservationPropertiesBaseResourceProperties)jsonReader.readObject(reader -> {
            ReservationPropertiesBaseResourceProperties deserializedReservationPropertiesBaseResourceProperties = new ReservationPropertiesBaseResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("marketplace".equals(fieldName)) {
                    deserializedReservationPropertiesBaseResourceProperties.marketplace = MarketplaceDetails.fromJson(reader);
                    continue;
                }
                if ("user".equals(fieldName)) {
                    deserializedReservationPropertiesBaseResourceProperties.user = UserDetails.fromJson(reader);
                    continue;
                }
                if ("reservationInternalId".equals(fieldName)) {
                    deserializedReservationPropertiesBaseResourceProperties.reservationInternalId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedReservationPropertiesBaseResourceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReservationPropertiesBaseResourceProperties;
        });
    }
}

