/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.purestorageblock.fluent.models.ReservationInner;
import com.azure.resourcemanager.purestorageblock.models.LimitDetails;
import com.azure.resourcemanager.purestorageblock.models.ReservationBillingStatus;
import com.azure.resourcemanager.purestorageblock.models.ReservationBillingUsageReport;
import com.azure.resourcemanager.purestorageblock.models.ReservationPropertiesBaseResourceProperties;
import com.azure.resourcemanager.purestorageblock.models.ReservationUpdateProperties;
import java.util.Map;

public interface Reservation {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ReservationPropertiesBaseResourceProperties properties();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ReservationInner innerModel();

    public Update update();

    public Reservation refresh();

    public Reservation refresh(Context var1);

    public Response<LimitDetails> getResourceLimitsWithResponse(Context var1);

    public LimitDetails getResourceLimits();

    public Response<ReservationBillingStatus> getBillingStatusWithResponse(Context var1);

    public ReservationBillingStatus getBillingStatus();

    public Response<ReservationBillingUsageReport> getBillingReportWithResponse(Context var1);

    public ReservationBillingUsageReport getBillingReport();

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(ReservationUpdateProperties var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithProperties {
        public Reservation apply();

        public Reservation apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithProperties {
            public WithCreate withProperties(ReservationPropertiesBaseResourceProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties {
            public Reservation create();

            public Reservation create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

