/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.RangeLimits;
import java.io.IOException;

public final class ProtectionPolicyLimits
implements JsonSerializable<ProtectionPolicyLimits> {
    private RangeLimits frequency;
    private RangeLimits retention;
    private static final ClientLogger LOGGER = new ClientLogger(ProtectionPolicyLimits.class);

    private ProtectionPolicyLimits() {
    }

    public RangeLimits frequency() {
        return this.frequency;
    }

    public RangeLimits retention() {
        return this.retention;
    }

    public void validate() {
        if (this.frequency() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property frequency in model ProtectionPolicyLimits"));
        }
        this.frequency().validate();
        if (this.retention() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property retention in model ProtectionPolicyLimits"));
        }
        this.retention().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("frequency", (JsonSerializable)this.frequency);
        jsonWriter.writeJsonField("retention", (JsonSerializable)this.retention);
        return jsonWriter.writeEndObject();
    }

    public static ProtectionPolicyLimits fromJson(JsonReader jsonReader) throws IOException {
        return (ProtectionPolicyLimits)jsonReader.readObject(reader -> {
            ProtectionPolicyLimits deserializedProtectionPolicyLimits = new ProtectionPolicyLimits();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frequency".equals(fieldName)) {
                    deserializedProtectionPolicyLimits.frequency = RangeLimits.fromJson(reader);
                    continue;
                }
                if ("retention".equals(fieldName)) {
                    deserializedProtectionPolicyLimits.retention = RangeLimits.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProtectionPolicyLimits;
        });
    }
}

