/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.RangeLimits;
import java.io.IOException;

public final class PerformancePolicyLimits
implements JsonSerializable<PerformancePolicyLimits> {
    private RangeLimits iopsLimit;
    private RangeLimits bandwidthLimit;
    private static final ClientLogger LOGGER = new ClientLogger(PerformancePolicyLimits.class);

    private PerformancePolicyLimits() {
    }

    public RangeLimits iopsLimit() {
        return this.iopsLimit;
    }

    public RangeLimits bandwidthLimit() {
        return this.bandwidthLimit;
    }

    public void validate() {
        if (this.iopsLimit() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property iopsLimit in model PerformancePolicyLimits"));
        }
        this.iopsLimit().validate();
        if (this.bandwidthLimit() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bandwidthLimit in model PerformancePolicyLimits"));
        }
        this.bandwidthLimit().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("iopsLimit", (JsonSerializable)this.iopsLimit);
        jsonWriter.writeJsonField("bandwidthLimit", (JsonSerializable)this.bandwidthLimit);
        return jsonWriter.writeEndObject();
    }

    public static PerformancePolicyLimits fromJson(JsonReader jsonReader) throws IOException {
        return (PerformancePolicyLimits)jsonReader.readObject(reader -> {
            PerformancePolicyLimits deserializedPerformancePolicyLimits = new PerformancePolicyLimits();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("iopsLimit".equals(fieldName)) {
                    deserializedPerformancePolicyLimits.iopsLimit = RangeLimits.fromJson(reader);
                    continue;
                }
                if ("bandwidthLimit".equals(fieldName)) {
                    deserializedPerformancePolicyLimits.bandwidthLimit = RangeLimits.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPerformancePolicyLimits;
        });
    }
}

