/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.BandwidthUsage;
import com.azure.resourcemanager.purestorageblock.models.IopsUsage;
import com.azure.resourcemanager.purestorageblock.models.Space;
import java.io.IOException;

public final class HealthDetails
implements JsonSerializable<HealthDetails> {
    private double usedCapacityPercentage;
    private BandwidthUsage bandwidthUsage;
    private IopsUsage iopsUsage;
    private Space space;
    private double dataReductionRatio;
    private long estimatedMaxCapacity;
    private static final ClientLogger LOGGER = new ClientLogger(HealthDetails.class);

    private HealthDetails() {
    }

    public double usedCapacityPercentage() {
        return this.usedCapacityPercentage;
    }

    public BandwidthUsage bandwidthUsage() {
        return this.bandwidthUsage;
    }

    public IopsUsage iopsUsage() {
        return this.iopsUsage;
    }

    public Space space() {
        return this.space;
    }

    public double dataReductionRatio() {
        return this.dataReductionRatio;
    }

    public long estimatedMaxCapacity() {
        return this.estimatedMaxCapacity;
    }

    public void validate() {
        if (this.bandwidthUsage() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bandwidthUsage in model HealthDetails"));
        }
        this.bandwidthUsage().validate();
        if (this.iopsUsage() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property iopsUsage in model HealthDetails"));
        }
        this.iopsUsage().validate();
        if (this.space() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property space in model HealthDetails"));
        }
        this.space().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("usedCapacityPercentage", this.usedCapacityPercentage);
        jsonWriter.writeJsonField("bandwidthUsage", (JsonSerializable)this.bandwidthUsage);
        jsonWriter.writeJsonField("iopsUsage", (JsonSerializable)this.iopsUsage);
        jsonWriter.writeJsonField("space", (JsonSerializable)this.space);
        jsonWriter.writeDoubleField("dataReductionRatio", this.dataReductionRatio);
        jsonWriter.writeLongField("estimatedMaxCapacity", this.estimatedMaxCapacity);
        return jsonWriter.writeEndObject();
    }

    public static HealthDetails fromJson(JsonReader jsonReader) throws IOException {
        return (HealthDetails)jsonReader.readObject(reader -> {
            HealthDetails deserializedHealthDetails = new HealthDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("usedCapacityPercentage".equals(fieldName)) {
                    deserializedHealthDetails.usedCapacityPercentage = reader.getDouble();
                    continue;
                }
                if ("bandwidthUsage".equals(fieldName)) {
                    deserializedHealthDetails.bandwidthUsage = BandwidthUsage.fromJson(reader);
                    continue;
                }
                if ("iopsUsage".equals(fieldName)) {
                    deserializedHealthDetails.iopsUsage = IopsUsage.fromJson(reader);
                    continue;
                }
                if ("space".equals(fieldName)) {
                    deserializedHealthDetails.space = Space.fromJson(reader);
                    continue;
                }
                if ("dataReductionRatio".equals(fieldName)) {
                    deserializedHealthDetails.dataReductionRatio = reader.getDouble();
                    continue;
                }
                if ("estimatedMaxCapacity".equals(fieldName)) {
                    deserializedHealthDetails.estimatedMaxCapacity = reader.getLong();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHealthDetails;
        });
    }
}

