/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.Address;
import java.io.IOException;

public final class CompanyDetails
implements JsonSerializable<CompanyDetails> {
    private String companyName;
    private Address address;
    private static final ClientLogger LOGGER = new ClientLogger(CompanyDetails.class);

    public String companyName() {
        return this.companyName;
    }

    public CompanyDetails withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public Address address() {
        return this.address;
    }

    public CompanyDetails withAddress(Address address) {
        this.address = address;
        return this;
    }

    public void validate() {
        if (this.companyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property companyName in model CompanyDetails"));
        }
        if (this.address() != null) {
            this.address().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("companyName", this.companyName);
        jsonWriter.writeJsonField("address", (JsonSerializable)this.address);
        return jsonWriter.writeEndObject();
    }

    public static CompanyDetails fromJson(JsonReader jsonReader) throws IOException {
        return (CompanyDetails)jsonReader.readObject(reader -> {
            CompanyDetails deserializedCompanyDetails = new CompanyDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("companyName".equals(fieldName)) {
                    deserializedCompanyDetails.companyName = reader.getString();
                    continue;
                }
                if ("address".equals(fieldName)) {
                    deserializedCompanyDetails.address = Address.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCompanyDetails;
        });
    }
}

