/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.UsageSeverity;
import java.io.IOException;
import java.util.List;

public final class BillingUsageProperty
implements JsonSerializable<BillingUsageProperty> {
    private String propertyId;
    private String propertyName;
    private String currentValue;
    private String previousValue;
    private UsageSeverity severity;
    private String statusMessage;
    private List<BillingUsageProperty> subProperties;
    private static final ClientLogger LOGGER = new ClientLogger(BillingUsageProperty.class);

    private BillingUsageProperty() {
    }

    public String propertyId() {
        return this.propertyId;
    }

    public String propertyName() {
        return this.propertyName;
    }

    public String currentValue() {
        return this.currentValue;
    }

    public String previousValue() {
        return this.previousValue;
    }

    public UsageSeverity severity() {
        return this.severity;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public List<BillingUsageProperty> subProperties() {
        return this.subProperties;
    }

    public void validate() {
        if (this.propertyId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property propertyId in model BillingUsageProperty"));
        }
        if (this.propertyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property propertyName in model BillingUsageProperty"));
        }
        if (this.currentValue() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property currentValue in model BillingUsageProperty"));
        }
        if (this.severity() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property severity in model BillingUsageProperty"));
        }
        if (this.subProperties() != null) {
            this.subProperties().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("propertyId", this.propertyId);
        jsonWriter.writeStringField("propertyName", this.propertyName);
        jsonWriter.writeStringField("currentValue", this.currentValue);
        jsonWriter.writeStringField("severity", this.severity == null ? null : this.severity.toString());
        jsonWriter.writeStringField("previousValue", this.previousValue);
        jsonWriter.writeStringField("statusMessage", this.statusMessage);
        jsonWriter.writeArrayField("subProperties", this.subProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BillingUsageProperty fromJson(JsonReader jsonReader) throws IOException {
        return (BillingUsageProperty)jsonReader.readObject(reader -> {
            BillingUsageProperty deserializedBillingUsageProperty = new BillingUsageProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("propertyId".equals(fieldName)) {
                    deserializedBillingUsageProperty.propertyId = reader.getString();
                    continue;
                }
                if ("propertyName".equals(fieldName)) {
                    deserializedBillingUsageProperty.propertyName = reader.getString();
                    continue;
                }
                if ("currentValue".equals(fieldName)) {
                    deserializedBillingUsageProperty.currentValue = reader.getString();
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedBillingUsageProperty.severity = UsageSeverity.fromString(reader.getString());
                    continue;
                }
                if ("previousValue".equals(fieldName)) {
                    deserializedBillingUsageProperty.previousValue = reader.getString();
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedBillingUsageProperty.statusMessage = reader.getString();
                    continue;
                }
                if ("subProperties".equals(fieldName)) {
                    List subProperties;
                    deserializedBillingUsageProperty.subProperties = subProperties = reader.readArray(reader1 -> BillingUsageProperty.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBillingUsageProperty;
        });
    }
}

