/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.AvsVmDetails;
import com.azure.resourcemanager.purestorageblock.models.ResourceProvisioningState;
import com.azure.resourcemanager.purestorageblock.models.SoftDeletion;
import com.azure.resourcemanager.purestorageblock.models.Space;
import com.azure.resourcemanager.purestorageblock.models.VolumeContainerType;
import java.io.IOException;

public final class AvsVmProperties
implements JsonSerializable<AvsVmProperties> {
    private String storagePoolInternalId;
    private String storagePoolResourceId;
    private String displayName;
    private String createdTimestamp;
    private SoftDeletion softDeletion;
    private VolumeContainerType volumeContainerType;
    private AvsVmDetails avs;
    private Space space;
    private ResourceProvisioningState provisioningState;

    private AvsVmProperties() {
    }

    public String storagePoolInternalId() {
        return this.storagePoolInternalId;
    }

    public String storagePoolResourceId() {
        return this.storagePoolResourceId;
    }

    public String displayName() {
        return this.displayName;
    }

    public String createdTimestamp() {
        return this.createdTimestamp;
    }

    public SoftDeletion softDeletion() {
        return this.softDeletion;
    }

    public VolumeContainerType volumeContainerType() {
        return this.volumeContainerType;
    }

    public AvsVmDetails avs() {
        return this.avs;
    }

    public Space space() {
        return this.space;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.softDeletion() != null) {
            this.softDeletion().validate();
        }
        if (this.avs() != null) {
            this.avs().validate();
        }
        if (this.space() != null) {
            this.space().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("softDeletion", (JsonSerializable)this.softDeletion);
        return jsonWriter.writeEndObject();
    }

    public static AvsVmProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AvsVmProperties)jsonReader.readObject(reader -> {
            AvsVmProperties deserializedAvsVmProperties = new AvsVmProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storagePoolInternalId".equals(fieldName)) {
                    deserializedAvsVmProperties.storagePoolInternalId = reader.getString();
                    continue;
                }
                if ("storagePoolResourceId".equals(fieldName)) {
                    deserializedAvsVmProperties.storagePoolResourceId = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedAvsVmProperties.displayName = reader.getString();
                    continue;
                }
                if ("createdTimestamp".equals(fieldName)) {
                    deserializedAvsVmProperties.createdTimestamp = reader.getString();
                    continue;
                }
                if ("softDeletion".equals(fieldName)) {
                    deserializedAvsVmProperties.softDeletion = SoftDeletion.fromJson(reader);
                    continue;
                }
                if ("volumeContainerType".equals(fieldName)) {
                    deserializedAvsVmProperties.volumeContainerType = VolumeContainerType.fromString(reader.getString());
                    continue;
                }
                if ("avs".equals(fieldName)) {
                    deserializedAvsVmProperties.avs = AvsVmDetails.fromJson(reader);
                    continue;
                }
                if ("space".equals(fieldName)) {
                    deserializedAvsVmProperties.space = Space.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAvsVmProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvsVmProperties;
        });
    }
}

