/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.VmType;
import java.io.IOException;

public final class AvsVmDetails
implements JsonSerializable<AvsVmDetails> {
    private String vmId;
    private String vmName;
    private VmType vmType;
    private String avsVmInternalId;
    private static final ClientLogger LOGGER = new ClientLogger(AvsVmDetails.class);

    private AvsVmDetails() {
    }

    public String vmId() {
        return this.vmId;
    }

    public String vmName() {
        return this.vmName;
    }

    public VmType vmType() {
        return this.vmType;
    }

    public String avsVmInternalId() {
        return this.avsVmInternalId;
    }

    public void validate() {
        if (this.vmId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vmId in model AvsVmDetails"));
        }
        if (this.vmName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vmName in model AvsVmDetails"));
        }
        if (this.vmType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vmType in model AvsVmDetails"));
        }
        if (this.avsVmInternalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property avsVmInternalId in model AvsVmDetails"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmId", this.vmId);
        jsonWriter.writeStringField("vmName", this.vmName);
        jsonWriter.writeStringField("vmType", this.vmType == null ? null : this.vmType.toString());
        jsonWriter.writeStringField("avsVmInternalId", this.avsVmInternalId);
        return jsonWriter.writeEndObject();
    }

    public static AvsVmDetails fromJson(JsonReader jsonReader) throws IOException {
        return (AvsVmDetails)jsonReader.readObject(reader -> {
            AvsVmDetails deserializedAvsVmDetails = new AvsVmDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vmId".equals(fieldName)) {
                    deserializedAvsVmDetails.vmId = reader.getString();
                    continue;
                }
                if ("vmName".equals(fieldName)) {
                    deserializedAvsVmDetails.vmName = reader.getString();
                    continue;
                }
                if ("vmType".equals(fieldName)) {
                    deserializedAvsVmDetails.vmType = VmType.fromString(reader.getString());
                    continue;
                }
                if ("avsVmInternalId".equals(fieldName)) {
                    deserializedAvsVmDetails.avsVmInternalId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvsVmDetails;
        });
    }
}

