/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.Space;
import java.io.IOException;

public final class AvsStorageContainerProperties
implements JsonSerializable<AvsStorageContainerProperties> {
    private Space space;
    private String resourceName;
    private Long provisionedLimit;
    private String datastore;
    private Boolean mounted;

    private AvsStorageContainerProperties() {
    }

    public Space space() {
        return this.space;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public Long provisionedLimit() {
        return this.provisionedLimit;
    }

    public String datastore() {
        return this.datastore;
    }

    public Boolean mounted() {
        return this.mounted;
    }

    public void validate() {
        if (this.space() != null) {
            this.space().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("provisionedLimit", (Number)this.provisionedLimit);
        return jsonWriter.writeEndObject();
    }

    public static AvsStorageContainerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AvsStorageContainerProperties)jsonReader.readObject(reader -> {
            AvsStorageContainerProperties deserializedAvsStorageContainerProperties = new AvsStorageContainerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceName".equals(fieldName)) {
                    deserializedAvsStorageContainerProperties.resourceName = reader.getString();
                    continue;
                }
                if ("space".equals(fieldName)) {
                    deserializedAvsStorageContainerProperties.space = Space.fromJson(reader);
                    continue;
                }
                if ("provisionedLimit".equals(fieldName)) {
                    deserializedAvsStorageContainerProperties.provisionedLimit = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("datastore".equals(fieldName)) {
                    deserializedAvsStorageContainerProperties.datastore = reader.getString();
                    continue;
                }
                if ("mounted".equals(fieldName)) {
                    deserializedAvsStorageContainerProperties.mounted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvsStorageContainerProperties;
        });
    }
}

