/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.models.AlertLevel;
import java.io.IOException;

public final class Alert
implements JsonSerializable<Alert> {
    private AlertLevel level;
    private String message;
    private static final ClientLogger LOGGER = new ClientLogger(Alert.class);

    private Alert() {
    }

    public AlertLevel level() {
        return this.level;
    }

    public String message() {
        return this.message;
    }

    public void validate() {
        if (this.level() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property level in model Alert"));
        }
        if (this.message() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property message in model Alert"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static Alert fromJson(JsonReader jsonReader) throws IOException {
        return (Alert)jsonReader.readObject(reader -> {
            Alert deserializedAlert = new Alert();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("level".equals(fieldName)) {
                    deserializedAlert.level = AlertLevel.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedAlert.message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAlert;
        });
    }
}

