/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Address
implements JsonSerializable<Address> {
    private String addressLine1;
    private String addressLine2;
    private String city;
    private String state;
    private String country;
    private String postalCode;
    private static final ClientLogger LOGGER = new ClientLogger(Address.class);

    public String addressLine1() {
        return this.addressLine1;
    }

    public Address withAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    public String addressLine2() {
        return this.addressLine2;
    }

    public Address withAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    public String city() {
        return this.city;
    }

    public Address withCity(String city) {
        this.city = city;
        return this;
    }

    public String state() {
        return this.state;
    }

    public Address withState(String state) {
        this.state = state;
        return this;
    }

    public String country() {
        return this.country;
    }

    public Address withCountry(String country) {
        this.country = country;
        return this;
    }

    public String postalCode() {
        return this.postalCode;
    }

    public Address withPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public void validate() {
        if (this.addressLine1() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property addressLine1 in model Address"));
        }
        if (this.city() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property city in model Address"));
        }
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model Address"));
        }
        if (this.country() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property country in model Address"));
        }
        if (this.postalCode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property postalCode in model Address"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("addressLine1", this.addressLine1);
        jsonWriter.writeStringField("city", this.city);
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("country", this.country);
        jsonWriter.writeStringField("postalCode", this.postalCode);
        jsonWriter.writeStringField("addressLine2", this.addressLine2);
        return jsonWriter.writeEndObject();
    }

    public static Address fromJson(JsonReader jsonReader) throws IOException {
        return (Address)jsonReader.readObject(reader -> {
            Address deserializedAddress = new Address();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("addressLine1".equals(fieldName)) {
                    deserializedAddress.addressLine1 = reader.getString();
                    continue;
                }
                if ("city".equals(fieldName)) {
                    deserializedAddress.city = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedAddress.state = reader.getString();
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedAddress.country = reader.getString();
                    continue;
                }
                if ("postalCode".equals(fieldName)) {
                    deserializedAddress.postalCode = reader.getString();
                    continue;
                }
                if ("addressLine2".equals(fieldName)) {
                    deserializedAddress.addressLine2 = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAddress;
        });
    }
}

