/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.fluent.models.ReservationInner;
import java.io.IOException;
import java.util.List;

public final class ReservationListResult
implements JsonSerializable<ReservationListResult> {
    private List<ReservationInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ReservationListResult.class);

    private ReservationListResult() {
    }

    public List<ReservationInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ReservationListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ReservationListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ReservationListResult)jsonReader.readObject(reader -> {
            ReservationListResult deserializedReservationListResult = new ReservationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedReservationListResult.value = value = reader.readArray(reader1 -> ReservationInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedReservationListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReservationListResult;
        });
    }
}

