/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.fluent.models.AvsVmVolumeInner;
import java.io.IOException;
import java.util.List;

public final class AvsVmVolumeListResult
implements JsonSerializable<AvsVmVolumeListResult> {
    private List<AvsVmVolumeInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(AvsVmVolumeListResult.class);

    private AvsVmVolumeListResult() {
    }

    public List<AvsVmVolumeInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model AvsVmVolumeListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static AvsVmVolumeListResult fromJson(JsonReader jsonReader) throws IOException {
        return (AvsVmVolumeListResult)jsonReader.readObject(reader -> {
            AvsVmVolumeListResult deserializedAvsVmVolumeListResult = new AvsVmVolumeListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedAvsVmVolumeListResult.value = value = reader.readArray(reader1 -> AvsVmVolumeInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedAvsVmVolumeListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvsVmVolumeListResult;
        });
    }
}

