/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.purestorageblock.fluent.models.AvsStorageContainerInner;
import java.io.IOException;
import java.util.List;

public final class AvsStorageContainerListResult
implements JsonSerializable<AvsStorageContainerListResult> {
    private List<AvsStorageContainerInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(AvsStorageContainerListResult.class);

    private AvsStorageContainerListResult() {
    }

    public List<AvsStorageContainerInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model AvsStorageContainerListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static AvsStorageContainerListResult fromJson(JsonReader jsonReader) throws IOException {
        return (AvsStorageContainerListResult)jsonReader.readObject(reader -> {
            AvsStorageContainerListResult deserializedAvsStorageContainerListResult = new AvsStorageContainerListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedAvsStorageContainerListResult.value = value = reader.readArray(reader1 -> AvsStorageContainerInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedAvsStorageContainerListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvsStorageContainerListResult;
        });
    }
}

