/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.purestorageblock.PureStorageBlockManager;
import com.azure.resourcemanager.purestorageblock.fluent.StoragePoolsClient;
import com.azure.resourcemanager.purestorageblock.fluent.models.AvsConnectionInner;
import com.azure.resourcemanager.purestorageblock.fluent.models.AvsStatusInner;
import com.azure.resourcemanager.purestorageblock.fluent.models.StoragePoolHealthInfoInner;
import com.azure.resourcemanager.purestorageblock.fluent.models.StoragePoolInner;
import com.azure.resourcemanager.purestorageblock.implementation.AvsConnectionImpl;
import com.azure.resourcemanager.purestorageblock.implementation.AvsStatusImpl;
import com.azure.resourcemanager.purestorageblock.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.purestorageblock.implementation.StoragePoolHealthInfoImpl;
import com.azure.resourcemanager.purestorageblock.implementation.StoragePoolImpl;
import com.azure.resourcemanager.purestorageblock.models.AvsConnection;
import com.azure.resourcemanager.purestorageblock.models.AvsStatus;
import com.azure.resourcemanager.purestorageblock.models.StoragePool;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolEnableAvsConnectionPost;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolFinalizeAvsConnectionPost;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolHealthInfo;
import com.azure.resourcemanager.purestorageblock.models.StoragePools;

public final class StoragePoolsImpl
implements StoragePools {
    private static final ClientLogger LOGGER = new ClientLogger(StoragePoolsImpl.class);
    private final StoragePoolsClient innerClient;
    private final PureStorageBlockManager serviceManager;

    public StoragePoolsImpl(StoragePoolsClient innerClient, PureStorageBlockManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<StoragePool> getByResourceGroupWithResponse(String resourceGroupName, String storagePoolName, Context context) {
        Response<StoragePoolInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, storagePoolName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new StoragePoolImpl((StoragePoolInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public StoragePool getByResourceGroup(String resourceGroupName, String storagePoolName) {
        StoragePoolInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, storagePoolName);
        if (inner != null) {
            return new StoragePoolImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String storagePoolName) {
        this.serviceClient().delete(resourceGroupName, storagePoolName);
    }

    @Override
    public void delete(String resourceGroupName, String storagePoolName, Context context) {
        this.serviceClient().delete(resourceGroupName, storagePoolName, context);
    }

    @Override
    public PagedIterable<StoragePool> listByResourceGroup(String resourceGroupName) {
        PagedIterable<StoragePoolInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StoragePoolImpl((StoragePoolInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StoragePool> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<StoragePoolInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StoragePoolImpl((StoragePoolInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StoragePool> list() {
        PagedIterable<StoragePoolInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StoragePoolImpl((StoragePoolInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StoragePool> list(Context context) {
        PagedIterable<StoragePoolInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StoragePoolImpl((StoragePoolInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<StoragePoolHealthInfo> getHealthStatusWithResponse(String resourceGroupName, String storagePoolName, Context context) {
        Response<StoragePoolHealthInfoInner> inner = this.serviceClient().getHealthStatusWithResponse(resourceGroupName, storagePoolName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new StoragePoolHealthInfoImpl((StoragePoolHealthInfoInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public StoragePoolHealthInfo getHealthStatus(String resourceGroupName, String storagePoolName) {
        StoragePoolHealthInfoInner inner = this.serviceClient().getHealthStatus(resourceGroupName, storagePoolName);
        if (inner != null) {
            return new StoragePoolHealthInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<AvsConnection> getAvsConnectionWithResponse(String resourceGroupName, String storagePoolName, Context context) {
        Response<AvsConnectionInner> inner = this.serviceClient().getAvsConnectionWithResponse(resourceGroupName, storagePoolName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AvsConnectionImpl((AvsConnectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AvsConnection getAvsConnection(String resourceGroupName, String storagePoolName) {
        AvsConnectionInner inner = this.serviceClient().getAvsConnection(resourceGroupName, storagePoolName);
        if (inner != null) {
            return new AvsConnectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<AvsStatus> getAvsStatusWithResponse(String resourceGroupName, String storagePoolName, Context context) {
        Response<AvsStatusInner> inner = this.serviceClient().getAvsStatusWithResponse(resourceGroupName, storagePoolName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AvsStatusImpl((AvsStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AvsStatus getAvsStatus(String resourceGroupName, String storagePoolName) {
        AvsStatusInner inner = this.serviceClient().getAvsStatus(resourceGroupName, storagePoolName);
        if (inner != null) {
            return new AvsStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void enableAvsConnection(String resourceGroupName, String storagePoolName, StoragePoolEnableAvsConnectionPost properties) {
        this.serviceClient().enableAvsConnection(resourceGroupName, storagePoolName, properties);
    }

    @Override
    public void enableAvsConnection(String resourceGroupName, String storagePoolName, StoragePoolEnableAvsConnectionPost properties, Context context) {
        this.serviceClient().enableAvsConnection(resourceGroupName, storagePoolName, properties, context);
    }

    @Override
    public void disableAvsConnection(String resourceGroupName, String storagePoolName) {
        this.serviceClient().disableAvsConnection(resourceGroupName, storagePoolName);
    }

    @Override
    public void disableAvsConnection(String resourceGroupName, String storagePoolName, Context context) {
        this.serviceClient().disableAvsConnection(resourceGroupName, storagePoolName, context);
    }

    @Override
    public void finalizeAvsConnection(String resourceGroupName, String storagePoolName, StoragePoolFinalizeAvsConnectionPost properties) {
        this.serviceClient().finalizeAvsConnection(resourceGroupName, storagePoolName, properties);
    }

    @Override
    public void finalizeAvsConnection(String resourceGroupName, String storagePoolName, StoragePoolFinalizeAvsConnectionPost properties, Context context) {
        this.serviceClient().finalizeAvsConnection(resourceGroupName, storagePoolName, properties, context);
    }

    @Override
    public void repairAvsConnection(String resourceGroupName, String storagePoolName) {
        this.serviceClient().repairAvsConnection(resourceGroupName, storagePoolName);
    }

    @Override
    public void repairAvsConnection(String resourceGroupName, String storagePoolName, Context context) {
        this.serviceClient().repairAvsConnection(resourceGroupName, storagePoolName, context);
    }

    @Override
    public StoragePool getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storagePoolName = ResourceManagerUtils.getValueFromIdByName(id, "storagePools");
        if (storagePoolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storagePools'.", id)));
        }
        return (StoragePool)this.getByResourceGroupWithResponse(resourceGroupName, storagePoolName, Context.NONE).getValue();
    }

    @Override
    public Response<StoragePool> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storagePoolName = ResourceManagerUtils.getValueFromIdByName(id, "storagePools");
        if (storagePoolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storagePools'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, storagePoolName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storagePoolName = ResourceManagerUtils.getValueFromIdByName(id, "storagePools");
        if (storagePoolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storagePools'.", id)));
        }
        this.delete(resourceGroupName, storagePoolName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storagePoolName = ResourceManagerUtils.getValueFromIdByName(id, "storagePools");
        if (storagePoolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storagePools'.", id)));
        }
        this.delete(resourceGroupName, storagePoolName, context);
    }

    private StoragePoolsClient serviceClient() {
        return this.innerClient;
    }

    private PureStorageBlockManager manager() {
        return this.serviceManager;
    }

    @Override
    public StoragePoolImpl define(String name) {
        return new StoragePoolImpl(name, this.manager());
    }
}

