/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.purestorageblock.PureStorageBlockManager;
import com.azure.resourcemanager.purestorageblock.fluent.models.StoragePoolInner;
import com.azure.resourcemanager.purestorageblock.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.purestorageblock.models.AvsConnection;
import com.azure.resourcemanager.purestorageblock.models.AvsStatus;
import com.azure.resourcemanager.purestorageblock.models.ManagedServiceIdentity;
import com.azure.resourcemanager.purestorageblock.models.StoragePool;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolEnableAvsConnectionPost;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolFinalizeAvsConnectionPost;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolHealthInfo;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolProperties;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolUpdate;
import com.azure.resourcemanager.purestorageblock.models.StoragePoolUpdateProperties;
import java.util.Collections;
import java.util.Map;

public final class StoragePoolImpl
implements StoragePool,
StoragePool.Definition,
StoragePool.Update {
    private StoragePoolInner innerObject;
    private final PureStorageBlockManager serviceManager;
    private String resourceGroupName;
    private String storagePoolName;
    private StoragePoolUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public StoragePoolProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public StoragePoolInner innerModel() {
        return this.innerObject;
    }

    private PureStorageBlockManager manager() {
        return this.serviceManager;
    }

    @Override
    public StoragePoolImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public StoragePool create() {
        this.innerObject = this.serviceManager.serviceClient().getStoragePools().create(this.resourceGroupName, this.storagePoolName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public StoragePool create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getStoragePools().create(this.resourceGroupName, this.storagePoolName, this.innerModel(), context);
        return this;
    }

    StoragePoolImpl(String name, PureStorageBlockManager serviceManager) {
        this.innerObject = new StoragePoolInner();
        this.serviceManager = serviceManager;
        this.storagePoolName = name;
    }

    @Override
    public StoragePoolImpl update() {
        this.updateProperties = new StoragePoolUpdate();
        return this;
    }

    @Override
    public StoragePool apply() {
        this.innerObject = this.serviceManager.serviceClient().getStoragePools().update(this.resourceGroupName, this.storagePoolName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public StoragePool apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getStoragePools().update(this.resourceGroupName, this.storagePoolName, this.updateProperties, context);
        return this;
    }

    StoragePoolImpl(StoragePoolInner innerObject, PureStorageBlockManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.storagePoolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "storagePools");
    }

    @Override
    public StoragePool refresh() {
        this.innerObject = (StoragePoolInner)((Object)this.serviceManager.serviceClient().getStoragePools().getByResourceGroupWithResponse(this.resourceGroupName, this.storagePoolName, Context.NONE).getValue());
        return this;
    }

    @Override
    public StoragePool refresh(Context context) {
        this.innerObject = (StoragePoolInner)((Object)this.serviceManager.serviceClient().getStoragePools().getByResourceGroupWithResponse(this.resourceGroupName, this.storagePoolName, context).getValue());
        return this;
    }

    @Override
    public Response<StoragePoolHealthInfo> getHealthStatusWithResponse(Context context) {
        return this.serviceManager.storagePools().getHealthStatusWithResponse(this.resourceGroupName, this.storagePoolName, context);
    }

    @Override
    public StoragePoolHealthInfo getHealthStatus() {
        return this.serviceManager.storagePools().getHealthStatus(this.resourceGroupName, this.storagePoolName);
    }

    @Override
    public Response<AvsConnection> getAvsConnectionWithResponse(Context context) {
        return this.serviceManager.storagePools().getAvsConnectionWithResponse(this.resourceGroupName, this.storagePoolName, context);
    }

    @Override
    public AvsConnection getAvsConnection() {
        return this.serviceManager.storagePools().getAvsConnection(this.resourceGroupName, this.storagePoolName);
    }

    @Override
    public Response<AvsStatus> getAvsStatusWithResponse(Context context) {
        return this.serviceManager.storagePools().getAvsStatusWithResponse(this.resourceGroupName, this.storagePoolName, context);
    }

    @Override
    public AvsStatus getAvsStatus() {
        return this.serviceManager.storagePools().getAvsStatus(this.resourceGroupName, this.storagePoolName);
    }

    @Override
    public void enableAvsConnection(StoragePoolEnableAvsConnectionPost properties) {
        this.serviceManager.storagePools().enableAvsConnection(this.resourceGroupName, this.storagePoolName, properties);
    }

    @Override
    public void enableAvsConnection(StoragePoolEnableAvsConnectionPost properties, Context context) {
        this.serviceManager.storagePools().enableAvsConnection(this.resourceGroupName, this.storagePoolName, properties, context);
    }

    @Override
    public void disableAvsConnection() {
        this.serviceManager.storagePools().disableAvsConnection(this.resourceGroupName, this.storagePoolName);
    }

    @Override
    public void disableAvsConnection(Context context) {
        this.serviceManager.storagePools().disableAvsConnection(this.resourceGroupName, this.storagePoolName, context);
    }

    @Override
    public void finalizeAvsConnection(StoragePoolFinalizeAvsConnectionPost properties) {
        this.serviceManager.storagePools().finalizeAvsConnection(this.resourceGroupName, this.storagePoolName, properties);
    }

    @Override
    public void finalizeAvsConnection(StoragePoolFinalizeAvsConnectionPost properties, Context context) {
        this.serviceManager.storagePools().finalizeAvsConnection(this.resourceGroupName, this.storagePoolName, properties, context);
    }

    @Override
    public void repairAvsConnection() {
        this.serviceManager.storagePools().repairAvsConnection(this.resourceGroupName, this.storagePoolName);
    }

    @Override
    public void repairAvsConnection(Context context) {
        this.serviceManager.storagePools().repairAvsConnection(this.resourceGroupName, this.storagePoolName, context);
    }

    @Override
    public StoragePoolImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public StoragePoolImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public StoragePoolImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public StoragePoolImpl withProperties(StoragePoolProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public StoragePoolImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateProperties.withIdentity(identity);
        return this;
    }

    @Override
    public StoragePoolImpl withProperties(StoragePoolUpdateProperties properties) {
        this.updateProperties.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

