/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.purestorageblock.PureStorageBlockManager;
import com.azure.resourcemanager.purestorageblock.fluent.ReservationsClient;
import com.azure.resourcemanager.purestorageblock.fluent.models.LimitDetailsInner;
import com.azure.resourcemanager.purestorageblock.fluent.models.ReservationBillingStatusInner;
import com.azure.resourcemanager.purestorageblock.fluent.models.ReservationBillingUsageReportInner;
import com.azure.resourcemanager.purestorageblock.fluent.models.ReservationInner;
import com.azure.resourcemanager.purestorageblock.implementation.LimitDetailsImpl;
import com.azure.resourcemanager.purestorageblock.implementation.ReservationBillingStatusImpl;
import com.azure.resourcemanager.purestorageblock.implementation.ReservationBillingUsageReportImpl;
import com.azure.resourcemanager.purestorageblock.implementation.ReservationImpl;
import com.azure.resourcemanager.purestorageblock.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.purestorageblock.models.LimitDetails;
import com.azure.resourcemanager.purestorageblock.models.Reservation;
import com.azure.resourcemanager.purestorageblock.models.ReservationBillingStatus;
import com.azure.resourcemanager.purestorageblock.models.ReservationBillingUsageReport;
import com.azure.resourcemanager.purestorageblock.models.Reservations;

public final class ReservationsImpl
implements Reservations {
    private static final ClientLogger LOGGER = new ClientLogger(ReservationsImpl.class);
    private final ReservationsClient innerClient;
    private final PureStorageBlockManager serviceManager;

    public ReservationsImpl(ReservationsClient innerClient, PureStorageBlockManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Reservation> getByResourceGroupWithResponse(String resourceGroupName, String reservationName, Context context) {
        Response<ReservationInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, reservationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ReservationImpl((ReservationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Reservation getByResourceGroup(String resourceGroupName, String reservationName) {
        ReservationInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, reservationName);
        if (inner != null) {
            return new ReservationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String reservationName) {
        this.serviceClient().delete(resourceGroupName, reservationName);
    }

    @Override
    public void delete(String resourceGroupName, String reservationName, Context context) {
        this.serviceClient().delete(resourceGroupName, reservationName, context);
    }

    @Override
    public PagedIterable<Reservation> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ReservationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReservationImpl((ReservationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Reservation> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ReservationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReservationImpl((ReservationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Reservation> list() {
        PagedIterable<ReservationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReservationImpl((ReservationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Reservation> list(Context context) {
        PagedIterable<ReservationInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReservationImpl((ReservationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<LimitDetails> getResourceLimitsWithResponse(String resourceGroupName, String reservationName, Context context) {
        Response<LimitDetailsInner> inner = this.serviceClient().getResourceLimitsWithResponse(resourceGroupName, reservationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LimitDetailsImpl((LimitDetailsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public LimitDetails getResourceLimits(String resourceGroupName, String reservationName) {
        LimitDetailsInner inner = this.serviceClient().getResourceLimits(resourceGroupName, reservationName);
        if (inner != null) {
            return new LimitDetailsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ReservationBillingStatus> getBillingStatusWithResponse(String resourceGroupName, String reservationName, Context context) {
        Response<ReservationBillingStatusInner> inner = this.serviceClient().getBillingStatusWithResponse(resourceGroupName, reservationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ReservationBillingStatusImpl((ReservationBillingStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ReservationBillingStatus getBillingStatus(String resourceGroupName, String reservationName) {
        ReservationBillingStatusInner inner = this.serviceClient().getBillingStatus(resourceGroupName, reservationName);
        if (inner != null) {
            return new ReservationBillingStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ReservationBillingUsageReport> getBillingReportWithResponse(String resourceGroupName, String reservationName, Context context) {
        Response<ReservationBillingUsageReportInner> inner = this.serviceClient().getBillingReportWithResponse(resourceGroupName, reservationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ReservationBillingUsageReportImpl((ReservationBillingUsageReportInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ReservationBillingUsageReport getBillingReport(String resourceGroupName, String reservationName) {
        ReservationBillingUsageReportInner inner = this.serviceClient().getBillingReport(resourceGroupName, reservationName);
        if (inner != null) {
            return new ReservationBillingUsageReportImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Reservation getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String reservationName = ResourceManagerUtils.getValueFromIdByName(id, "reservations");
        if (reservationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'reservations'.", id)));
        }
        return (Reservation)this.getByResourceGroupWithResponse(resourceGroupName, reservationName, Context.NONE).getValue();
    }

    @Override
    public Response<Reservation> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String reservationName = ResourceManagerUtils.getValueFromIdByName(id, "reservations");
        if (reservationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'reservations'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, reservationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String reservationName = ResourceManagerUtils.getValueFromIdByName(id, "reservations");
        if (reservationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'reservations'.", id)));
        }
        this.delete(resourceGroupName, reservationName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String reservationName = ResourceManagerUtils.getValueFromIdByName(id, "reservations");
        if (reservationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'reservations'.", id)));
        }
        this.delete(resourceGroupName, reservationName, context);
    }

    private ReservationsClient serviceClient() {
        return this.innerClient;
    }

    private PureStorageBlockManager manager() {
        return this.serviceManager;
    }

    @Override
    public ReservationImpl define(String name) {
        return new ReservationImpl(name, this.manager());
    }
}

