/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.purestorageblock.PureStorageBlockManager;
import com.azure.resourcemanager.purestorageblock.fluent.models.ReservationInner;
import com.azure.resourcemanager.purestorageblock.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.purestorageblock.models.LimitDetails;
import com.azure.resourcemanager.purestorageblock.models.Reservation;
import com.azure.resourcemanager.purestorageblock.models.ReservationBillingStatus;
import com.azure.resourcemanager.purestorageblock.models.ReservationBillingUsageReport;
import com.azure.resourcemanager.purestorageblock.models.ReservationPropertiesBaseResourceProperties;
import com.azure.resourcemanager.purestorageblock.models.ReservationUpdate;
import com.azure.resourcemanager.purestorageblock.models.ReservationUpdateProperties;
import java.util.Collections;
import java.util.Map;

public final class ReservationImpl
implements Reservation,
Reservation.Definition,
Reservation.Update {
    private ReservationInner innerObject;
    private final PureStorageBlockManager serviceManager;
    private String resourceGroupName;
    private String reservationName;
    private ReservationUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ReservationPropertiesBaseResourceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ReservationInner innerModel() {
        return this.innerObject;
    }

    private PureStorageBlockManager manager() {
        return this.serviceManager;
    }

    @Override
    public ReservationImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Reservation create() {
        this.innerObject = this.serviceManager.serviceClient().getReservations().create(this.resourceGroupName, this.reservationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Reservation create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getReservations().create(this.resourceGroupName, this.reservationName, this.innerModel(), context);
        return this;
    }

    ReservationImpl(String name, PureStorageBlockManager serviceManager) {
        this.innerObject = new ReservationInner();
        this.serviceManager = serviceManager;
        this.reservationName = name;
    }

    @Override
    public ReservationImpl update() {
        this.updateProperties = new ReservationUpdate();
        return this;
    }

    @Override
    public Reservation apply() {
        this.innerObject = this.serviceManager.serviceClient().getReservations().update(this.resourceGroupName, this.reservationName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public Reservation apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getReservations().update(this.resourceGroupName, this.reservationName, this.updateProperties, context);
        return this;
    }

    ReservationImpl(ReservationInner innerObject, PureStorageBlockManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.reservationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "reservations");
    }

    @Override
    public Reservation refresh() {
        this.innerObject = (ReservationInner)((Object)this.serviceManager.serviceClient().getReservations().getByResourceGroupWithResponse(this.resourceGroupName, this.reservationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Reservation refresh(Context context) {
        this.innerObject = (ReservationInner)((Object)this.serviceManager.serviceClient().getReservations().getByResourceGroupWithResponse(this.resourceGroupName, this.reservationName, context).getValue());
        return this;
    }

    @Override
    public Response<LimitDetails> getResourceLimitsWithResponse(Context context) {
        return this.serviceManager.reservations().getResourceLimitsWithResponse(this.resourceGroupName, this.reservationName, context);
    }

    @Override
    public LimitDetails getResourceLimits() {
        return this.serviceManager.reservations().getResourceLimits(this.resourceGroupName, this.reservationName);
    }

    @Override
    public Response<ReservationBillingStatus> getBillingStatusWithResponse(Context context) {
        return this.serviceManager.reservations().getBillingStatusWithResponse(this.resourceGroupName, this.reservationName, context);
    }

    @Override
    public ReservationBillingStatus getBillingStatus() {
        return this.serviceManager.reservations().getBillingStatus(this.resourceGroupName, this.reservationName);
    }

    @Override
    public Response<ReservationBillingUsageReport> getBillingReportWithResponse(Context context) {
        return this.serviceManager.reservations().getBillingReportWithResponse(this.resourceGroupName, this.reservationName, context);
    }

    @Override
    public ReservationBillingUsageReport getBillingReport() {
        return this.serviceManager.reservations().getBillingReport(this.resourceGroupName, this.reservationName);
    }

    @Override
    public ReservationImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ReservationImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ReservationImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public ReservationImpl withProperties(ReservationPropertiesBaseResourceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ReservationImpl withProperties(ReservationUpdateProperties properties) {
        this.updateProperties.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

