/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.purestorageblock.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.purestorageblock.PureStorageBlockManager;
import com.azure.resourcemanager.purestorageblock.fluent.AvsVmsClient;
import com.azure.resourcemanager.purestorageblock.fluent.models.AvsVmInner;
import com.azure.resourcemanager.purestorageblock.implementation.AvsVmImpl;
import com.azure.resourcemanager.purestorageblock.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.purestorageblock.models.AvsVm;
import com.azure.resourcemanager.purestorageblock.models.AvsVmUpdate;
import com.azure.resourcemanager.purestorageblock.models.AvsVms;

public final class AvsVmsImpl
implements AvsVms {
    private static final ClientLogger LOGGER = new ClientLogger(AvsVmsImpl.class);
    private final AvsVmsClient innerClient;
    private final PureStorageBlockManager serviceManager;

    public AvsVmsImpl(AvsVmsClient innerClient, PureStorageBlockManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public AvsVm update(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties) {
        AvsVmInner inner = this.serviceClient().update(resourceGroupName, storagePoolName, avsVmId, properties);
        if (inner != null) {
            return new AvsVmImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AvsVm update(String resourceGroupName, String storagePoolName, String avsVmId, AvsVmUpdate properties, Context context) {
        AvsVmInner inner = this.serviceClient().update(resourceGroupName, storagePoolName, avsVmId, properties, context);
        if (inner != null) {
            return new AvsVmImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<AvsVm> getWithResponse(String resourceGroupName, String storagePoolName, String avsVmId, Context context) {
        Response<AvsVmInner> inner = this.serviceClient().getWithResponse(resourceGroupName, storagePoolName, avsVmId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AvsVmImpl((AvsVmInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AvsVm get(String resourceGroupName, String storagePoolName, String avsVmId) {
        AvsVmInner inner = this.serviceClient().get(resourceGroupName, storagePoolName, avsVmId);
        if (inner != null) {
            return new AvsVmImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String storagePoolName, String avsVmId) {
        this.serviceClient().delete(resourceGroupName, storagePoolName, avsVmId);
    }

    @Override
    public void delete(String resourceGroupName, String storagePoolName, String avsVmId, Context context) {
        this.serviceClient().delete(resourceGroupName, storagePoolName, avsVmId, context);
    }

    @Override
    public PagedIterable<AvsVm> listByStoragePool(String resourceGroupName, String storagePoolName) {
        PagedIterable<AvsVmInner> inner = this.serviceClient().listByStoragePool(resourceGroupName, storagePoolName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvsVmImpl((AvsVmInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AvsVm> listByStoragePool(String resourceGroupName, String storagePoolName, Context context) {
        PagedIterable<AvsVmInner> inner = this.serviceClient().listByStoragePool(resourceGroupName, storagePoolName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvsVmImpl((AvsVmInner)((Object)inner1), this.manager()));
    }

    private AvsVmsClient serviceClient() {
        return this.innerClient;
    }

    private PureStorageBlockManager manager() {
        return this.serviceManager;
    }
}

